<?php
// config.php - Színek és alapbeállítások
$config = [
    'colors' => [
        'primary' => '#889999',
        'secondary' => '#3885a4', 
        'tertiary' => '#55616b',
        'accent' => '#f4e3c4',
        'white' => '#ffffff'
    ],
    'site_name' => 'BDSTEEL - Lakatosmunkák',
    'site_description' => 'Minőségi acélmegmunkálások és professzionális fémmunkák otthonokhoz és üzletekhez.',
    'site_url' => 'https://steel.bdcleaning.hu',
    'logo_path' => '/assets/logo_web.png',
    'logo_width' => 159,
    'logo_height' => 50,
    'contact' => [
        'phone' => '+36 70 609 6667',
        'phone_raw' => '+36706096667',
        'email_main' => 'bdsteel94@gmail.com',
        'email_support' => 'ugyfelszolgalat@bdsteel.hu',
        'address' => '1173 Budapest, Bátor utca 10.'
    ],
    'seo' => [
        'keywords' => 'lakatosmunkák Budapest, fémszerkezetek, lépcsőépítés, ajtózár szerelés, biztonsági rácsok, kerítések kapuk, vasszerkezet gyártás, hegesztés, acélmegmunkálás, műhely berendezések, rakodó rámpák',
        'author' => 'BDSTEEL Lakatosmunkák',
        'favicon' => '/assets/fav.png',
        'og_image' => '/assets/ogimage.jpg'
    ]
];

// SEO adatok oldalanként
$seo_pages = [
    'home' => [
        'title' => 'BDSTEEL Lakatosmunkák Budapest - Fémszerkezetek, Lépcsőépítés',
        'description' => 'Professzionális lakatosmunkák Budapesten ✓ Fémszerkezetek ✓ Lépcsőépítés ✓ Ajtózárak ✓ Biztonsági rácsok ✓ 15+ év tapasztalat ✓ Ingyenes árajánlat',
        'keywords' => 'lakatosmunkák Budapest, BDSTEEL, fémszerkezetek, lépcsőépítés, ajtózár szerelés, biztonsági rácsok, kerítések, vasszerkezet, hegesztés, acélmegmunkálás',
        'og_title' => 'BDSTEEL - Professzionális Lakatosmunkák és Fémszerkezetek Budapesten',
        'og_description' => 'Évtizedes tapasztalat a lakatosmunkák, lépcsőépítés és fémszerkezetek területén. Minőségi acélmegmunkálások otthonokhoz és üzletekhez. Ingyenes árajánlat!'
    ],
    'lakatosmunkak' => [
        'title' => 'Lakatosmunkák Budapest - Ajtózárak, Biztonsági Rácsok | BDSTEEL',
        'description' => 'Szakértő lakatosmunkák Budapesten ✓ Ajtózár szerelés ✓ Biztonsági rácsok ✓ Kerítések, kapuk ✓ Vészhelyzeti szolgáltatás ✓ 24/7 elérhetőség ✓ Garanciával',
        'keywords' => 'lakatosmunkák Budapest, ajtózár szerelés, biztonsági rácsok, kerítések kapuk, kapuk automatizálása, vészhelyzeti zárnyitás, kulcsmásolás, lakatosipari munkák',
        'og_title' => 'Professzionális Lakatosmunkák Budapesten - BDSTEEL',
        'og_description' => 'Komplett lakatosipari szolgáltatások: ajtózárak, biztonsági rácsok, kerítések, kapuk automatizálása. Vészhelyzeti szolgáltatás 24/7. Ingyenes árajánlat!'
    ],
    'lepcsoepitest' => [
        'title' => 'Lépcsőépítés Budapest - Beltéri, Kültéri Lépcsők | BDSTEEL',
        'description' => 'Egyedi lépcsőszerkezetek Budapesten ✓ Beltéri lépcsők ✓ Kültéri lépcsők ✓ Lépcsőtartók ✓ Korlátok ✓ Modern dizájn ✓ Szakértő tervezés és kivitelezés',
        'keywords' => 'lépcsőépítés Budapest, lépcsőszerkezetek, beltéri lépcsők, kültéri lépcsők, lépcsőtartók, korlátok, lépcső tervezés, acél lépcsők, modern lépcsők',
        'og_title' => 'Lépcsőépítés és Lépcsőszerkezetek Budapesten - BDSTEEL',
        'og_description' => 'Egyedi lépcsőszerkezetek tervezése és kivitelezése. Beltéri és kültéri lépcsők, innovatív lépcsőtartók, stílusos korlátok. Helyszíni felmérés ingyen!'
    ],
    'lepcsoepites' => [
        'title' => 'Lépcsőépítés Budapest - Beltéri, Kültéri Lépcsők | BDSTEEL',
        'description' => 'Egyedi lépcsőszerkezetek Budapesten ✓ Beltéri lépcsők ✓ Kültéri lépcsők ✓ Lépcsőtartók ✓ Korlátok ✓ Modern dizájn ✓ Szakértő tervezés és kivitelezés',
        'keywords' => 'lépcsőépítés Budapest, lépcsőszerkezetek, beltéri lépcsők, kültéri lépcsők, lépcsőtartók, korlátok, lépcső tervezés, acél lépcsők, modern lépcsők',
        'og_title' => 'Lépcsőépítés és Lépcsőszerkezetek Budapesten - BDSTEEL',
        'og_description' => 'Egyedi lépcsőszerkezetek tervezése és kivitelezése. Beltéri és kültéri lépcsők, innovatív lépcsőtartók, stílusos korlátok. Helyszíni felmérés ingyen!'
    ],
    'femszerkezetek' => [
        'title' => 'Fémszerkezetek Budapest - Vasszerkezetek, Ipari Megoldások | BDSTEEL',
        'description' => 'Komplex fémszerkezetek Budapesten ✓ Vasszerkezet gyártás ✓ Ipari megoldások ✓ Tetőszerkezetek ✓ Műhely berendezések ✓ Acélszerkezetes építmények',
        'keywords' => 'fémszerkezetek Budapest, vasszerkezet gyártás, ipari fémszerkezetek, tetőszerkezetek, acélszerkezetek, műhely berendezések, rakodó rámpák, hegesztés',
        'og_title' => 'Fémszerkezetek és Vasszerkezetek Budapesten - BDSTEEL',
        'og_description' => 'Komplex fémszerkezeti projektek kivitelezése. Vasszerkezet gyártás, ipari megoldások, tetőszerkezetek. CAD tervezés, minőségi anyagok, szakértő kivitelezés.'
    ],
    'kapcsolat' => [
        'title' => 'Kapcsolat - BDSTEEL Lakatosmunkák Budapest | Ingyenes Árajánlat',
        'description' => 'Vegye fel a kapcsolatot velünk ✓ Telefon: +36 70 609 6667 ✓ Budapest, Bátor utca 10. ✓ Ingyenes konzultáció ✓ Gyors árajánlat ✓ Helyszíni felmérés',
        'keywords' => 'BDSTEEL kapcsolat, lakatosmunkák Budapest, árajánlat, konzultáció, helyszíni felmérés, Bátor utca, szakértő tanácsadás, ingyenes árajánlat',
        'og_title' => 'Kapcsolat - BDSTEEL Lakatosmunkák Budapest',
        'og_description' => 'Vegye fel velünk a kapcsolatot lakatosmunkák, lépcsőépítés és fémszerkezetek ügyében. Ingyenes konzultáció és árajánlat. Budapest, Bátor utca 10.'
    ],
    'lepcso-szerkezet-epitese' => [
        'title' => 'Lépcső Szerkezet Építése Budapest - Beltéri és Kültéri | BDSTEEL',
        'description' => 'Professzionális lépcső szerkezetek építése ✓ Beltéri lépcsők ✓ Kültéri lépcsők ✓ Egyedi tervezés ✓ Tartós anyagok ✓ Szakértő kivitelezés',
        'keywords' => 'lépcső szerkezet építése, beltéri lépcsők, kültéri lépcsők, lépcsőépítés Budapest, acél lépcsők, lépcső tervezés',
        'og_title' => 'Lépcső Szerkezet Építése - BDSTEEL Budapest',
        'og_description' => 'Szakértő lépcső szerkezet építés beltérre és kültérre. Egyedi tervezés, tartós anyagok, precíz kivitelezés.'
    ],
    'korlatok-kivitelezese' => [
        'title' => 'Korlátok Kivitelezése Budapest - Lépcsőkorlátok | BDSTEEL',
        'description' => 'Stílusos lépcsőkorlátok kivitelezése ✓ Beltéri korlátok ✓ Kültéri korlátok ✓ Biztonsági elemek ✓ Egyedi dizájn ✓ Időjárásálló kivitelezés',
        'keywords' => 'korlátok kivitelezése, lépcsőkorlátok, beltéri korlátok, kültéri korlátok, biztonsági korlátok Budapest',
        'og_title' => 'Korlátok Kivitelezése - BDSTEEL Budapest',
        'og_description' => 'Professzionális lépcsőkorlátok és biztonsági korlátok kivitelezése. Beltéri és kültéri megoldások egyedi tervezéssel.'
    ],
    'kapuk-keritesek-felujitasa' => [
        'title' => 'Kapuk és Kerítések Felújítása Budapest | BDSTEEL',
        'description' => 'Meglévő kapuk és kerítések szakszerű felújítása ✓ Festés ✓ Javítás ✓ Megerősítés ✓ Modernizálás ✓ Automatizálás ✓ Hosszú élettartam',
        'keywords' => 'kapuk felújítása, kerítések felújítása, kapu javítás, kerítés javítás, felújítás Budapest',
        'og_title' => 'Kapuk és Kerítések Felújítása - BDSTEEL Budapest',
        'og_description' => 'Meglévő kapuk és kerítések szakszerű felújítása. Festés, javítás, megerősítés és modernizálás tapasztalt szakemberekkel.'
    ],
    'keritesek-kapuk-gyartasa' => [
        'title' => 'Kerítések és Kapuk Gyártása Budapest | BDSTEEL',
        'description' => 'Egyedi kerítések és kapuk gyártása ✓ Modern dizájn ✓ Tartós anyagok ✓ Automatizálási lehetőség ✓ Szakértő telepítés ✓ Garanciával',
        'keywords' => 'kerítések gyártása, kapuk gyártása, új kerítés, új kapu, automatikus kapuk Budapest',
        'og_title' => 'Kerítések és Kapuk Gyártása - BDSTEEL Budapest',
        'og_description' => 'Egyedi kerítések és kapuk gyártása modern dizájnnal. Automatizálási lehetőséggel, szakértő telepítéssel és garanciával.'
    ],
    'biztonsagi-racs-keszites' => [
        'title' => 'Biztonsági Rács Készítés Budapest - Ablak és Ajtó Rácsok | BDSTEEL',
        'description' => 'Biztonsági rácsok készítése ✓ Ablakrácsok ✓ Ajtórácsok ✓ Egyedi méretek ✓ Biztonságos rögzítés ✓ Esztétikus kivitelezés',
        'keywords' => 'biztonsági rács készítés, ablakrácsok, ajtórácsok, védőrácsok, biztonsági rácsok Budapest',
        'og_title' => 'Biztonsági Rács Készítés - BDSTEEL Budapest',
        'og_description' => 'Egyedi biztonsági rácsok készítése ablakokhoz és ajtókhoz. Biztonságos rögzítés és esztétikus kivitelezés.'
    ],
    'rakodo-rampak' => [
        'title' => 'Rakodó Rámpák Gyártása és Telepítése Budapest | BDSTEEL',
        'description' => 'Ipari rakodó rámpák gyártása ✓ Telepítés ✓ Nagy teherbírás ✓ Biztonságos kialakítás ✓ Tartós konstrukció ✓ Egyedi méretek',
        'keywords' => 'rakodó rámpák gyártása, rakodó rámpák telepítése, ipari rámpák, tehergépjármű rámpák Budapest',
        'og_title' => 'Rakodó Rámpák Gyártása és Telepítése - BDSTEEL Budapest',
        'og_description' => 'Ipari rakodó rámpák gyártása és szakszerű telepítése. Nagy teherbírású, biztonságos konstrukciók egyedi méretekben.'
    ],
    'vasszerkezet-gyartas' => [
        'title' => 'Vasszerkezet Gyártás Budapest - Ipari Fémszerkezetek | BDSTEEL',
        'description' => 'Professzionális vasszerkezet gyártás ✓ Ipari megoldások ✓ Tetőszerkezetek ✓ Tartószerkezetek ✓ Mérnöki tervezés ✓ Precíz kivitelezés',
        'keywords' => 'vasszerkezet gyártás, ipari fémszerkezetek, tetőszerkezetek, tartószerkezetek, acélszerkezetek Budapest',
        'og_title' => 'Vasszerkezet Gyártás - BDSTEEL Budapest',
        'og_description' => 'Komplex vasszerkezet gyártás ipari és építőipari projektekhez. Mérnöki tervezés és precíz kivitelezés.'
    ],
    'muhely-uzletberendezes' => [
        'title' => 'Műhely Üzletberendezés Gyártása Budapest | BDSTEEL',
        'description' => 'Egyedi műhely berendezések gyártása ✓ Munkaasztalok ✓ Tárolórendszerek ✓ Ipari bútorok ✓ Optimalizált kialakítás ✓ Tartós megoldások',
        'keywords' => 'műhely berendezések, munkaasztalok, tárolórendszerek, ipari bútorok, műhely felszerelés Budapest',
        'og_title' => 'Műhely Üzletberendezés Gyártása - BDSTEEL Budapest',
        'og_description' => 'Egyedi műhely berendezések gyártása: munkaasztalok, tárolórendszerek, ipari bútorok. Optimalizált kialakítás a hatékony munkavégzéshez.'
    ]
];
?>