<!-- Footer -->
    <footer class="bg-tertiary text-white">
        <div class="container mx-auto px-4 py-12">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Cég információk -->
                <div>
                    <h3 class="text-xl font-bold mb-4 text-accent">BDSTEEL - Lakatosmunkák</h3>
                    <p class="text-gray-300 mb-4">
                        Minőségi acélmegmunkálások és professzionális fémmunkák otthonokhoz és üzletekhez. 
                        Évtizedes szakértelem, megbízható kivitelezés.
                    </p>
                    <div class="flex space-x-4">
                        <i class="fas fa-tools text-accent text-2xl"></i>
                        <i class="fas fa-hammer text-accent text-2xl"></i>
                        <i class="fas fa-wrench text-accent text-2xl"></i>
                    </div>
                </div>
                
                <!-- Szolgáltatások -->
                <div>
                    <h3 class="text-xl font-bold mb-4 text-accent">Szolgáltatásaink</h3>
                    <ul class="space-y-2 text-gray-300">
                        <li><a href="/lakatosmunkak" class="hover:text-accent transition-colors">Lakatosmunkák</a></li>
                        <li><a href="/lepcsoepites" class="hover:text-accent transition-colors">Lépcsőépítés</a></li>
                        <li><a href="/femszerkezetek" class="hover:text-accent transition-colors">Fémszerkezetek</a></li>
                        <li class="text-gray-400">Biztonsági rácsok</li>
                        <li class="text-gray-400">Kerítések, kapuk</li>
                        <li class="text-gray-400">Rakodó rámpák</li>
                    </ul>
                </div>
                
                <!-- Elérhetőségek -->
                <div>
                    <h3 class="text-xl font-bold mb-4 text-accent">Elérhetőségek</h3>
                    <div class="space-y-3 text-gray-300">
                        <div class="flex items-center">
                            <i class="fas fa-phone text-accent mr-3"></i>
                            <a href="tel:<?php echo $config['contact']['phone_raw']; ?>" class="hover:text-accent transition-colors"><?php echo $config['contact']['phone']; ?></a>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-envelope text-accent mr-3"></i>
                            <a href="mailto:<?php echo $config['contact']['email_main']; ?>" class="hover:text-accent transition-colors"><?php echo $config['contact']['email_main']; ?></a>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-envelope text-accent mr-3"></i>
                            <a href="mailto:<?php echo $config['contact']['email_support']; ?>" class="hover:text-accent transition-colors"><?php echo $config['contact']['email_support']; ?></a>
                        </div>
                        <div class="flex items-start">
                            <i class="fas fa-map-marker-alt text-accent mr-3 mt-1"></i>
                            <span><?php echo $config['contact']['address']; ?></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray-600 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; <?php echo date('Y'); ?> BDSTEEL - Lakatosmunkák. Minden jog fenntartva.</p>
                <p class="mt-2 text-sm">Professzionális lakatosmunkák, lépcsőépítés és fémszerkezetek Budapesten és környékén.</p>
            </div>
        </div>
    </footer>
    
    <!-- Scroll to top gomb -->
    <button id="scroll-to-top" class="fixed bottom-6 right-6 bg-secondary hover:bg-secondary-dark text-white w-12 h-12 rounded-full shadow-lg transition-all duration-300 opacity-0 invisible flex items-center justify-center">
        <i class="fas fa-arrow-up"></i>
    </button>

    <script>
        // Scroll to top funkció
        const scrollToTopBtn = document.getElementById('scroll-to-top');
        
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                scrollToTopBtn.classList.add('opacity-100', 'visible');
                scrollToTopBtn.classList.remove('opacity-0', 'invisible');
            } else {
                scrollToTopBtn.classList.remove('opacity-100', 'visible');
                scrollToTopBtn.classList.add('opacity-0', 'invisible');
            }
        });
        
        scrollToTopBtn.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>
</body>
</html>