<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php
    // SEO adatok betöltése
    global $seo_pages;
    $current_seo = isset($seo_pages[$current_page]) ? $seo_pages[$current_page] : $seo_pages['home'];
    
    // Egyedi cím és leírás, vagy alapértelmezett
    $final_title = isset($page_title) && $page_title ? $page_title . ' - ' . $config['site_name'] : $current_seo['title'];
    $final_description = isset($page_description) && $page_description ? $page_description : $current_seo['description'];
    ?>
    
    <!-- Alapvető SEO meta tagek -->
    <title><?php echo htmlspecialchars($final_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($final_description); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($current_seo['keywords']); ?>">
    <meta name="author" content="<?php echo htmlspecialchars($config['seo']['author']); ?>">
    <meta name="robots" content="index, follow">
    <meta name="language" content="Hungarian">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $config['seo']['favicon']; ?>">
    <link rel="shortcut icon" type="image/png" href="<?php echo $config['seo']['favicon']; ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $config['site_url'] . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:title" content="<?php echo htmlspecialchars($current_seo['og_title']); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($current_seo['og_description']); ?>">
    <meta property="og:image" content="<?php echo $config['site_url'] . $config['seo']['og_image']; ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:locale" content="hu_HU">
    <meta property="og:site_name" content="<?php echo htmlspecialchars($config['site_name']); ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="<?php echo $config['site_url'] . $_SERVER['REQUEST_URI']; ?>">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($current_seo['og_title']); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($current_seo['og_description']); ?>">
    <meta name="twitter:image" content="<?php echo $config['site_url'] . $config['seo']['og_image']; ?>">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo $config['site_url'] . $_SERVER['REQUEST_URI']; ?>">
    
    <!-- JSON-LD strukturált adatok -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "LocalBusiness",
        "name": "<?php echo $config['site_name']; ?>",
        "description": "<?php echo $config['site_description']; ?>",
        "url": "<?php echo $config['site_url']; ?>",
        "telephone": "<?php echo $config['contact']['phone']; ?>",
        "email": "<?php echo $config['contact']['email_main']; ?>",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "Bátor utca 10.",
            "addressLocality": "Budapest",
            "postalCode": "1173",
            "addressCountry": "HU"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": "47.4251",
            "longitude": "19.2547"
        },
        "openingHours": "Mo-Fr 08:00-17:00",
        "serviceArea": {
            "@type": "GeoCircle",
            "geoMidpoint": {
                "@type": "GeoCoordinates",
                "latitude": "47.4251",
                "longitude": "19.2547"
            },
            "geoRadius": "50000"
        },
        "priceRange": "$",
        "image": "<?php echo $config['site_url'] . $config['seo']['og_image']; ?>",
        "logo": "<?php echo $config['site_url'] . $config['logo_path']; ?>",
        "sameAs": [],
        "hasOfferCatalog": {
            "@type": "OfferCatalog",
            "name": "Lakatosmunkák és Fémszerkezetek",
            "itemListElement": [
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Lakatosmunkák",
                        "description": "Professzionális lakatosipari szolgáltatások: ajtózárak, biztonsági rácsok, kerítések"
                    }
                },
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Lépcsőépítés",
                        "description": "Egyedi lépcsőszerkezetek tervezése és kivitelezése beltérre és kültérre"
                    }
                },
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Fémszerkezetek",
                        "description": "Komplex fémszerkezeti projektek, vasszerkezet gyártás, ipari megoldások"
                    }
                }
            ]
        }
    }
    </script>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#889999',
                        'secondary': '#3885a4',
                        'tertiary': '#55616b',
                        'accent': '#f4e3c4',
                        'primary-light': '#9aa6a6',
                        'primary-dark': '#778888',
                        'secondary-light': '#4a94b7',
                        'secondary-dark': '#2f7091',
                        'tertiary-light': '#667278',
                        'tertiary-dark': '#44505e',
                        'accent-light': '#f7e9d1',
                        'accent-dark': '#f1ddb7'
                    }
                }
            }
        }
    </script>
    
    <!-- Font Awesome ikonok -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Egyedi stílusok -->
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #889999 0%, #3885a4 100%);
        }
        .text-shadow {
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        .nav-link {
            @apply text-tertiary font-medium;
        }
        .nav-link:not(.active):hover {
            @apply text-secondary;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <header class="bg-white shadow-lg sticky top-0 z-50">
        <div class="container mx-auto px-4">
            <nav class="flex items-center justify-between py-4">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="/" class="flex items-center hover:opacity-80 transition-opacity">
                        <img src="<?php echo $config['logo_path']; ?>" 
                             alt="<?php echo $config['site_name']; ?>" 
                             width="<?php echo $config['logo_width']; ?>" 
                             height="<?php echo $config['logo_height']; ?>"
                             class="h-12 w-auto">
                    </a>
                </div>
                
                <!-- Desktop menü -->
                <div class="hidden md:flex space-x-2 items-center">
                    <a href="/" class="nav-link px-4 py-2 rounded-lg transition-all duration-300 <?php echo ($current_page == 'home') ? 'active bg-accent text-tertiary-dark' : 'hover:bg-gray-100'; ?>">
                        <i class="fas fa-home mr-2"></i>Főoldal
                    </a>
                    
                    <!-- Szolgáltatások dropdown -->
                    <div class="relative group">
                        <button class="nav-link px-4 py-2 rounded-lg transition-all duration-300 hover:bg-gray-100 flex items-center">
                            <i class="fas fa-cogs mr-2"></i>Szolgáltatások
                            <i class="fas fa-chevron-down ml-2 text-sm transition-transform duration-300 group-hover:rotate-180"></i>
                        </button>
                        <div class="absolute top-full left-0 mt-2 w-80 bg-white rounded-xl shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 transform translate-y-2 group-hover:translate-y-0 z-50">
                            <div class="p-4 space-y-2">
                                <a href="/lepcso-szerkezet-epitese" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Lépcső szerkezet építése
                                </a>
                                <a href="/korlatok-kivitelezese" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Korlátok kivitelezése
                                </a>
                                <a href="/kapuk-keritesek-felujitasa" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Meglévő kapuk, kerítések felújítása
                                </a>
                                <a href="/keritesek-kapuk-gyartasa" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Kerítések, kapuk gyártása
                                </a>
                                <a href="/biztonsagi-racs-keszites" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Biztonsági rács készítés
                                </a>
                                <a href="/rakodo-rampak" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Rakodó rámpák gyártása, telepítése
                                </a>
                                <a href="/vasszerkezet-gyartas" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Vasszerkezet gyártás
                                </a>
                                <a href="/muhely-uzletberendezes" class="block px-4 py-3 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300">
                                    Műhely üzletberendezés gyártása
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <a href="/galeria" class="nav-link px-4 py-2 rounded-lg transition-all duration-300 <?php echo ($current_page == 'galeria') ? 'active bg-accent text-tertiary-dark' : 'hover:bg-gray-100'; ?>">
                        <i class="fas fa-images mr-2"></i>Galéria
                    </a>
                    
                    <a href="/kapcsolat" class="nav-link px-4 py-2 rounded-lg transition-all duration-300 <?php echo ($current_page == 'kapcsolat') ? 'active bg-accent text-tertiary-dark' : 'hover:bg-gray-100'; ?>">
                        <i class="fas fa-envelope mr-2"></i>Kapcsolat
                    </a>
                </div>
                
                <!-- Mobil menü gomb -->
                <button class="md:hidden text-primary hover:text-secondary" id="mobile-menu-btn">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </nav>
            
            <!-- Mobil menü -->
            <div class="md:hidden hidden" id="mobile-menu">
                <div class="py-4 space-y-2 border-t">
                    <a href="/" class="block py-3 px-4 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300 <?php echo ($current_page == 'home') ? 'bg-accent text-tertiary-dark shadow-md' : ''; ?>">
                        <i class="fas fa-home mr-3"></i>Főoldal
                    </a>
                    
                    <!-- Szolgáltatások mobil accordion -->
                    <div class="space-y-1">
                        <button class="w-full text-left py-3 px-4 text-tertiary hover:bg-gray-100 rounded-xl transition-all duration-300 flex items-center justify-between" onclick="toggleMobileServices()">
                            <span><i class="fas fa-cogs mr-3"></i>Szolgáltatások</span>
                            <i class="fas fa-chevron-down transition-transform duration-300" id="mobile-services-arrow"></i>
                        </button>
                        <div class="ml-4 space-y-1 hidden" id="mobile-services">
                            <a href="/lepcso-szerkezet-epitese" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Lépcső szerkezet építése
                            </a>
                            <a href="/korlatok-kivitelezese" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Korlátok kivitelezése
                            </a>
                            <a href="/kapuk-keritesek-felujitasa" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Meglévő kapuk, kerítések felújítása
                            </a>
                            <a href="/keritesek-kapuk-gyartasa" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Kerítések, kapuk gyártása
                            </a>
                            <a href="/biztonsagi-racs-keszites" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Biztonsági rács készítés
                            </a>
                            <a href="/rakodo-rampak" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Rakodó rámpák gyártása, telepítése
                            </a>
                            <a href="/vasszerkezet-gyartas" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Vasszerkezet gyártás
                            </a>
                            <a href="/muhely-uzletberendezes" class="block py-2 px-4 text-sm text-gray-600 hover:bg-accent hover:text-tertiary-dark rounded-lg transition-all duration-300">
                                Műhely üzletberendezés gyártása
                            </a>
                        </div>
                    </div>
                    
                    <a href="/galeria" class="block py-3 px-4 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300 <?php echo ($current_page == 'galeria') ? 'bg-accent text-tertiary-dark shadow-md' : ''; ?>">
                        <i class="fas fa-images mr-3"></i>Galéria
                    </a>
                    
                    <a href="/kapcsolat" class="block py-3 px-4 text-tertiary hover:bg-accent hover:text-tertiary-dark rounded-xl transition-all duration-300 <?php echo ($current_page == 'kapcsolat') ? 'bg-accent text-tertiary-dark shadow-md' : ''; ?>">
                        <i class="fas fa-envelope mr-3"></i>Kapcsolat
                    </a>
                </div>
            </div>
        </div>
    </header>

    <script>
        // Mobil menü toggle
        document.getElementById('mobile-menu-btn').addEventListener('click', function() {
            const mobileMenu = document.getElementById('mobile-menu');
            mobileMenu.classList.toggle('hidden');
        });
        
        // Mobil szolgáltatások accordion
        function toggleMobileServices() {
            const servicesDiv = document.getElementById('mobile-services');
            const arrow = document.getElementById('mobile-services-arrow');
            
            servicesDiv.classList.toggle('hidden');
            arrow.classList.toggle('rotate-180');
        }
    </script>