<?php
http_response_code(404);
$page_title = '404 - Oldal nem található';
$page_description = 'A keresett oldal nem található a BDSTEEL honlapján. Tekintse meg szolgáltatásainkat: lakatosmunkák, lépcsőépítés, fémszerkezetek Budapesten.';
include 'header.php';
?>

<!-- 404 Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-gray-100 via-accent/30 to-gray-200 overflow-hidden">
    <div class="container mx-auto px-4 text-center">
        <div class="max-w-4xl mx-auto">
            <!-- 404 szám -->
            <div class="text-8xl md:text-9xl font-bold text-tertiary mb-6 opacity-20 select-none">
                404
            </div>
            
            <!-- Ikon -->
            <div class="bg-gradient-to-br from-secondary to-secondary-dark w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-8 shadow-lg">
                <i class="fas fa-search text-white text-4xl"></i>
            </div>
            
            <h1 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                Oldal nem található
            </h1>
            <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto leading-relaxed">
                Sajnos a keresett oldal nem található vagy át lett helyezve. 
                De ne izguljon, segítünk megtalálni amit keres!
            </p>
            
            <!-- Gyors navigáció gombok -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center mb-12">
                <a href="/" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                    <i class="fas fa-home mr-2"></i>Főoldal
                </a>
                <a href="/kapcsolat" class="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                    <i class="fas fa-phone mr-2"></i>Kapcsolat
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatások gyors elérés -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-tertiary mb-6">Vagy tekintse meg szolgáltatásainkat</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Talán az alábbi szolgáltatások egyike az, amit keresett?
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Lakatosmunkák -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-tools text-white text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Lakatosmunkák</h3>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Ajtózárak, biztonsági rácsok, kerítések, kapuk automatizálása és minden lakatosipari munka.
                </p>
                <a href="/lakatosmunkak" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                    Részletek <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
            
            <!-- Lépcsőépítés -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-stairs text-white text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Lépcsőépítés</h3>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Egyedi lépcsőszerkezetek tervezése és kivitelezése beltérre és kültérre, modern lépcsőtartókkal.
                </p>
                <a href="/lepcsoepitest" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                    Részletek <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
            
            <!-- Fémszerkezetek -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-industry text-white text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Fémszerkezetek</h3>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Komplex fémszerkezeti projektek, vasszerkezet gyártás, ipari megoldások és műhely berendezések.
                </p>
                <a href="/femszerkezetek" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                    Részletek <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Kapcsolatfelvétel -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="bg-white rounded-3xl shadow-xl p-8 md:p-12 text-center max-w-4xl mx-auto">
            <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-8">
                <i class="fas fa-question-circle text-tertiary text-3xl"></i>
            </div>
            
            <h2 class="text-3xl md:text-4xl font-bold text-tertiary mb-6">
                Nem találja amit keres?
            </h2>
            <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                Vegye fel velünk a kapcsolatot! Tapasztalt szakembereink szívesen segítenek minden 
                lakatosmunkával, lépcsőépítéssel és fémszerkezeti projekttel kapcsolatos kérdésben.
            </p>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="flex items-center justify-center space-x-3 bg-gray-50 rounded-xl p-4">
                    <i class="fas fa-phone text-secondary text-xl"></i>
                    <div class="text-left">
                        <div class="font-semibold text-tertiary">Telefonon</div>
                        <div class="text-sm text-gray-600"><?php echo $config['contact']['phone']; ?></div>
                    </div>
                </div>
                
                <div class="flex items-center justify-center space-x-3 bg-gray-50 rounded-xl p-4">
                    <i class="fas fa-envelope text-secondary text-xl"></i>
                    <div class="text-left">
                        <div class="font-semibold text-tertiary">E-mailben</div>
                        <div class="text-sm text-gray-600"><?php echo $config['contact']['email_main']; ?></div>
                    </div>
                </div>
                
                <div class="flex items-center justify-center space-x-3 bg-gray-50 rounded-xl p-4">
                    <i class="fas fa-map-marker-alt text-secondary text-xl"></i>
                    <div class="text-left">
                        <div class="font-semibold text-tertiary">Személyesen</div>
                        <div class="text-sm text-gray-600">Budapest</div>
                    </div>
                </div>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="tel:<?php echo $config['contact']['phone_raw']; ?>" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                    <i class="fas fa-phone mr-2"></i>Hívjon most
                </a>
                <a href="/kapcsolat" class="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                    <i class="fas fa-envelope mr-2"></i>Kapcsolat oldal
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Hasznos tippek -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-tertiary mb-6">Hasznos tippek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Néhány javaslat, hogy megtalálja amit keres
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-gray-50 rounded-2xl p-6 text-center hover:shadow-lg transition-shadow duration-300">
                <i class="fas fa-home text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Főoldal</h4>
                <p class="text-gray-600 text-sm">Tekintse meg szolgáltatásaink összefoglalóját</p>
            </div>
            
            <div class="bg-gray-50 rounded-2xl p-6 text-center hover:shadow-lg transition-shadow duration-300">
                <i class="fas fa-search text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Keresés</h4>
                <p class="text-gray-600 text-sm">Használja a böngésző keresés funkcióját</p>
            </div>
            
            <div class="bg-gray-50 rounded-2xl p-6 text-center hover:shadow-lg transition-shadow duration-300">
                <i class="fas fa-images text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Galéria</h4>
                <p class="text-gray-600 text-sm">Nézze meg munkáinkat a főoldalon</p>
            </div>
            
            <div class="bg-gray-50 rounded-2xl p-6 text-center hover:shadow-lg transition-shadow duration-300">
                <i class="fas fa-phone text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Kérdezzen</h4>
                <p class="text-gray-600 text-sm">Hívjon minket bizalommal</p>
            </div>
        </div>
    </div>
</section>

<script>
// Automatikus átirányítás a főoldalra 30 másodperc után (opcionális)
// setTimeout(function() {
//     if (confirm('Szeretné, hogy átirányítsuk a főoldalra?')) {
//         window.location.href = '/';
//     }
// }, 30000);

// Keresés funkció a 404 oldalon
document.addEventListener('keydown', function(e) {
    if (e.ctrlKey && e.key === 'f') {
        e.preventDefault();
        alert('Használja a menüt a navigáláshoz, vagy vegye fel velünk a kapcsolatot!');
    }
});
</script>

<?php include 'footer.php'; ?>