<?php
$page_title = 'Biztonsági Rács Készítés';
$page_description = 'Egyedi biztonsági rácsok készítése Budapesten - ablakrácsok, ajtórácsok, védőrácsok. BDSTEEL tartós, magas minőségű acélból készített biztonsági rácsok helyszíni felméréssel.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-secondary via-primary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            <span class="text-accent">Biztonsági Rács</span> Készítés
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Otthona és értékei védelméért. Vállaljuk egyedi méretű és formájú biztonsági rácsok készítését, 
            amelyek hatékony védelmet nyújtanak ablakainak, ajtóinak vagy más nyílászáróinak.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Helyszíni felmérés
            </a>
            <a href="#racstipusok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-shield-alt mr-2"></i>Rács típusok
            </a>
        </div>
    </div>
</section>

<!-- Biztonsági rácsok típusai -->
<section id="racstipusok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Tartós és megbízható védelem</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Tartós, magas minőségű acélból dolgozunk, így rácsaink nemcsak megbízható biztonságot biztosítanak, 
                hanem ellenállnak az időjárás viszontagságainak is.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Ablakrácsok -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-window-maximize text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ablakrácsok</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Egyedi méretű ablakrácsok minden típusú ablakhoz. Hatékony védelmet nyújtanak 
                        az illetéktelen behatolás ellen, miközben nem akadályozzák a természetes fény bejutását.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyedi méretek minden ablakhoz
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Hatékony behatolás elleni védelem
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Természetes fény átjutása
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Tartós acélból készült
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-ruler mr-2"></i>
                            Minden ablakrács pontos méretek alapján, egyedi igények szerint készül
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Ajtórácsok -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-door-open text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ajtórácsok</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Speciális ajtórácsok, amelyek megőrzik az ajtó funkcionalitását, 
                        miközben extra biztonsági réteget adnak otthonának. Különböző nyitási mechanizmusokkal elérhetők.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ajtó funkcionalitás megőrzése
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Extra biztonsági réteg
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Különböző nyitási mechanizmusok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Kényelmes használat
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-key mr-2"></i>
                            Ajtórácsaink praktikus nyitási megoldásokkal és zárrendszerrel
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Egyedi tervezés és méretek -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Minden rácsot <span class="text-secondary">egyedi igények</span> szerint tervezünk
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Minden rácsot ügyfeleink igényei szerint tervezünk és gyártunk, legyen szó klasszikus vagy modern stílusról, 
                    illetve speciális biztonsági követelményekről. Helyszíni felmérés után gyors és precíz beépítéssel gondoskodunk róla.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-palette text-secondary mr-3"></i>
                            Klasszikus és modern stílus
                        </h4>
                        <p class="text-gray-600">Minden építészeti stílushoz illeszkedő tervezési megoldások</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Speciális biztonsági követelmények
                        </h4>
                        <p class="text-gray-600">Fokozott biztonságú megoldások különleges igényekhez</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-hammer text-secondary mr-3"></i>
                            Gyors és precíz beépítés
                        </h4>
                        <p class="text-gray-600">Szakszerű telepítés minimális kellemetlenséggel</p>
                    </div>
                </div>
            </div>
            
            <!-- Egyedi jellemzők -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Egyedi tervezés előnyei</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-drafting-compass text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Pontos illeszkedés</h5>
                        <p class="text-sm text-gray-600">Tökéletes illeszkedés minden nyílászáróhoz</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-eye text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Esztétikus megjelenés</h5>
                        <p class="text-sm text-gray-600">Harmonikus illeszkedés az épület stílusához</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-lock text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Optimális biztonság</h5>
                        <p class="text-sm text-gray-600">Az adott helyszín igényeihez szabott védelem</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-tools text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Funkcionális design</h5>
                        <p class="text-sm text-gray-600">Praktikus és használható megoldások</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Anyagminőség és tartósság -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Magas minőségű acélból</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Csak a legmagasabb minőségű acélt használjuk, amely garantálja a hosszú élettartamot 
                és az időjárás viszontagságaival szembeni ellenállást
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Anyagminőség -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-gem text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Kiváló anyagminőség</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Tartós, magas minőségű acélból dolgozunk, amely garantálja a konstrukció 
                        stabilitását és hosszú élettartamát minden körülmény között.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Magas minőségű acél</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tartós konstrukció</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Stabil kialakítás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Hosszú élettartam</li>
                    </ul>
                </div>
            </div>
            
            <!-- Időjárásállóság -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-cloud-rain text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Időjárásállóság</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Rácsaink ellenállnak az időjárás viszontagságainak. Speciális felületkezelés 
                        védi a rozsdásodástól és az UV sugárzástól.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Rozsdásodás elleni védelem</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>UV álló felületkezelés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Extrém időjárás ellenálló</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Minimális karbantartás</li>
                    </ul>
                </div>
            </div>
            
            <!-- Megbízható biztonság -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Megbízható biztonság</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Rácsaink nemcsak megbízható biztonságot biztosítanak az illetéktelen behatolás ellen, 
                        hanem tartós védelmet nyújtanak értékei számára.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Behatolás elleni védelem</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Értékek védelme</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Megbízható konstrukció</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tartós biztonság</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Helyszíni felmérés és beépítés -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Helyszíni felmérés és gyors beépítés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Helyszíni felmérés után gyors és precíz beépítéssel gondoskodunk róla, 
                hogy otthona védelme maximális legyen
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Helyszíni felmérés</h3>
                <p class="text-gray-600">Pontos méretfelvétel és igények egyeztetése a helyszínen</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Egyedi tervezés</h3>
                <p class="text-gray-600">Személyre szabott rácstervezés a méretek és igények alapján</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Precíz gyártás</h3>
                <p class="text-gray-600">Magas minőségű acélból történő precíz műhelyi gyártás</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Gyors beépítés</h3>
                <p class="text-gray-600">Szakszerű és gyors telepítés minimális zavarással</p>
            </div>
        </div>
    </div>
</section>

<!-- Maximális védelem -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Maximális védelem otthonának</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Válassza szolgáltatásunkat, ha tartós, esztétikus és megbízható biztonsági rácsra van szüksége!
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-home text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Otthona védelme</h3>
                <p class="opacity-90">Komplett védelem lakóházak és társasházak számára</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-gem text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Értékei biztonsága</h3>
                <p class="opacity-90">Megbízható védelem értékes tárgyak és dokumentumok számára</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-heart text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Családja nyugalma</h3>
                <p class="opacity-90">Biztonságérzet és nyugalom minden családtag számára</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Védelmezze otthonát egyedi biztonsági ráccsal!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes helyszíni felméréséért és egyedi árajánlatért. 
            Minden biztonsági rács egyedi méretek és igények szerint készül.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-ruler mr-2"></i>Helyszíni felmérés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>