<?php
$page_title = 'Fémszerkezetek';
$page_description = 'Egyedi fémszerkezetek és vasszerkezetek készítése Budapesten - ipari megoldások, műhely berendezések, acélszerkezetek. BDSTEEL komplex fémszerkezeti projektek kivitelezése.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-tertiary via-primary to-secondary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Egyedi <span class="text-accent">Fémszerkezetek</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Komplex és nagyléptékű projektek kivitelezésére specializálódott fémszerkezeti divízió. 
            Vasszerkezetek gyártásától kezdve a legbonyolultabb ipari megoldásokig minden fémmegmunkálási igényt kielégítünk.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Projekt konzultáció
            </a>
            <a href="#vasszerkezetek" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-industry mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Vasszerkezet gyártás -->
<section id="vasszerkezetek" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Vasszerkezet gyártás és telepítés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Tartószerkezetek, gerendák és oszlopok gyártása építőipari projektekhez. 
                Minden vasszerkezet mérnöki számítások alapján, a vonatkozó szabványoknak megfelelően készül.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Építőipari vasszerkezetek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-building text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Építőipari vasszerkezetek</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Tartószerkezetek, gerendák és oszlopok gyártása építőipari projektekhez. 
                        Minden vasszerkezet mérnöki számítások alapján, a vonatkozó szabványoknak megfelelően készül.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Tartószerkezetek és gerendák
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Acél oszlopok gyártása
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Mérnöki számítások alapján
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Szabványos kivitelezés
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-calculator mr-2"></i>
                            Minden vasszerkezet statikai számítások alapján készül
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Ipari vasszerkezetek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-industry text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ipari vasszerkezetek</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Nagy teherbírású ipari vasszerkezetek gyártása üzemekhez, raktárakhoz és 
                        termelő létesítményekhez. Speciális igények szerint tervezett és kivitelezett megoldások.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Üzemi vasszerkezetek
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Raktári megoldások
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Nagy teherbírás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Speciális igények szerint
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-weight-hanging mr-2"></i>
                            Nagy teherbírású megoldások ipari környezethez
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Tetőszerkezetek és acélvázak -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Tetőszerkezetek és <span class="text-secondary">acélvázak</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Komplett acél tetőszerkezetek tervezése és kivitelezése. Könnyű, mégis rendkívül stabil 
                    megoldások, amelyek hosszú távon megbízható védelmet nyújtanak minden időjárási körülmény között.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-home text-secondary mr-3"></i>
                            Könnyű szerkezetek
                        </h4>
                        <p class="text-gray-600">Optimalizált súlyú acélszerkezetek nagy fesztávolságokhoz</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Rendkívül stabil
                        </h4>
                        <p class="text-gray-600">Nagy teherbírású megoldások extrém időjárási körülményekhez</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-clock text-secondary mr-3"></i>
                            Hosszú élettartam
                        </h4>
                        <p class="text-gray-600">Tartós megoldások speciális felületkezeléssel</p>
                    </div>
                </div>
            </div>
            
            <!-- Tetőszerkezet típusok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Tetőszerkezet típusaink</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-warehouse text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Ipari csarnokok</h5>
                        <p class="text-sm text-gray-600">Nagy fesztávolságú tetőszerkezetek</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-store text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Kereskedelmi épületek</h5>
                        <p class="text-sm text-gray-600">Modern és funkcionális megoldások</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-car text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Garázsok és tárolók</h5>
                        <p class="text-sm text-gray-600">Praktikus és tartós szerkezetek</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-tools text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Műhelyek</h5>
                        <p class="text-sm text-gray-600">Munkavégzésre optimalizált terek</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Speciális fémszerkezetek -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Speciális fémszerkezetek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Egyedi műhelyberendezések, ipari megoldások és komplex konstrukciók tervezése és kivitelezése
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Műhely üzletberendezés -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-toolbox text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Műhely üzletberendezés</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Egyedi műhelyberendezések, munkaasztalok, tárolórendszerek és ipari bútorok készítése. 
                        Minden berendezés a konkrét munkavégzési igényekhez optimalizálva.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Munkaasztalok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tárolórendszerek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Ipari bútorok</li>
                    </ul>
                </div>
            </div>
            
            <!-- Ipari megoldások -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-cogs text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Ipari megoldások</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Összetett ipari fémszerkezetek tervezése és kivitelezése egyedi igények szerint. 
                        Konténerek, tartályok, szállítórendszerek és speciális célú konstrukciók.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Konténerek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tartályok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Szállítórendszerek</li>
                    </ul>
                </div>
            </div>
            
            <!-- Acélszerkezetes építmények -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-building text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Acélszerkezetes építmények</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Teljes acélszerkezetes épületek tervezése és kivitelezése. 
                        Gyors építésű, költséghatékony és környezetbarát megoldások.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Gyors építés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Költséghatékony</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Környezetbarát</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Fémszerkezeti szolgáltatások előnyei -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Fémszerkezeti szolgáltatásaink előnyei</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Precíz tervezés, minőségi alapanyagok és korszerű technológiák alkalmazása minden projektnél
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Precíz tervezés -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-drafting-compass text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Precíz tervezés és kivitelezés</h3>
                <p class="text-gray-600 leading-relaxed">
                    Minden fémszerkezeti projekt részletes mérnöki tervezéssel kezdődik. 
                    CAD rendszerek alkalmazása és statikai számítások biztosítják a konstrukciók biztonságát.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• CAD tervezés</li>
                        <li>• Statikai számítások</li>
                        <li>• Biztonsági tervezés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Minőségi anyagok -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-gem text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Minőségi alapanyagok</h3>
                <p class="text-gray-600 leading-relaxed">
                    Csak a legmagasabb minőségű acél és fém alapanyagokat használjuk. 
                    Minden anyag rendelkezik a szükséges tanúsítványokkal és megfelelőségi igazolásokkal.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• Tanúsított anyagok</li>
                        <li>• Megfelelőségi igazolások</li>
                        <li>• Kiváló minőség</li>
                    </ul>
                </div>
            </div>
            
            <!-- Korszerű technológiák -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-microchip text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Korszerű technológiák</h3>
                <p class="text-gray-600 leading-relaxed">
                    Modern hegesztési, vágási és alakítási technológiák alkalmazása. 
                    Precíz munkavégzés és tökéletes felületminőség minden projektnél.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• Modern hegesztés</li>
                        <li>• Precíz vágás</li>
                        <li>• Tökéletes felületminőség</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Komplex projektek -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Komplex projektek kivitelezése</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                A BDSTEEL fémszerkezeti szakértelme lehetővé teszi a legösszetettebb projektek kivitelezését is
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-lightbulb text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Egyedi tervezés</h3>
                <p class="opacity-90">Minden projekt egyedi tervezésű és igényekhez igazított</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-eye text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Funkció és esztétika</h3>
                <p class="opacity-90">Nemcsak funkcionalitás, hanem esztétikus megjelenés is</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-clock text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Tartósság</h3>
                <p class="opacity-90">Hosszú távú elégedettséget garantáló megoldások</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-handshake text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Megbízhatóság</h3>
                <p class="opacity-90">Évek óta bizonyított szakértelem és megbízhatóság</p>
            </div>
        </div>
    </div>
</section>

<!-- Projekt típusok -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Fémszerkezeti projekt típusaink</h2>
            <p class="text-xl text-gray-700 max-w-3xl mx-auto">
                Kis léptékű egyedi megoldásoktól a nagyipari beruházásokig minden megrendelést szakmai alapossággal teljesítünk
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-home text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Lakóépületek</h4>
                <p class="text-gray-600 text-sm">Családi házak és társasházak acélszerkezetei</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-building text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Irodaépületek</h4>
                <p class="text-gray-600 text-sm">Modern irodaházak fémszerkezetei</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-industry text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Ipari létesítmények</h4>
                <p class="text-gray-600 text-sm">Gyárak és üzemek nagy teherbírású szerkezetei</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-warehouse text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Raktárak</h4>
                <p class="text-gray-600 text-sm">Logisztikai központok acélszerkezetei</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-store text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Kereskedelmi</h4>
                <p class="text-gray-600 text-sm">Bevásárlóközpontok és üzletek</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-graduation-cap text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Oktatási</h4>
                <p class="text-gray-600 text-sm">Iskolák és egyetemek fémszerkezetei</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Valósítsa meg fémszerkezeti projektjét velünk!
        </h2>
        <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot komplex fémszerkezeti projektjével kapcsolatban. 
            Ingyenes konzultáció, részletes tervezés és precíz kivitelezés garantáltan.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Projekt megbeszélés
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-calculator mr-2"></i>Árajánlat kérés
            </a>
        </div>
        
        <!-- Statisztikák -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mt-16 pt-16 border-t border-gray-200">
            <div class="group">
                <div class="text-4xl md:text-5xl font-bold text-secondary mb-2 group-hover:scale-110 transition-transform duration-300">300+</div>
                <div class="text-gray-600 font-semibold">Fémszerkezeti projekt</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-5xl font-bold text-primary mb-2 group-hover:scale-110 transition-transform duration-300">50+</div>
                <div class="text-gray-600 font-semibold">Ipari megoldás</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-5xl font-bold text-tertiary mb-2 group-hover:scale-110 transition-transform duration-300">15+</div>
                <div class="text-gray-600 font-semibold">Év tapasztalat</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-5xl font-bold text-secondary mb-2 group-hover:scale-110 transition-transform duration-300">100%</div>
                <div class="text-gray-600 font-semibold">Garancia</div>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>