<?php
$page_title = 'Galéria';
$page_description = 'BDSTEEL munkáink galéria - lakatosmunkák, lépcsőépítés és fémszerkezetek képei. Tekintse meg befejezett projektjeinket Budapesten és környékén.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Munkáink <span class="text-accent">Galéria</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Tekintse meg eddigi projektjeinket! Lakatosmunkáktól a komplex fémszerkezetekig - 
            minden munkánk a minőség és precizitás jegyében született.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="/kapcsolat" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Kérjen árajánlatot
            </a>
            <a href="#galeria-grid" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-images mr-2"></i>Képek megtekintése
            </a>
        </div>
    </div>
</section>

<!-- Munkáink galéria -->
<?php include 'gallery.php'; ?>

<!-- Szolgáltatások áttekintő -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Szolgáltatásaink</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden képen látható munka az alábbi szolgáltatásaink egyikébe tartozik
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-stairs text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Lépcsőépítés</h4>
                <p class="text-gray-600 text-sm">Egyedi lépcsőszerkezetek beltérre és kültérre</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-shield-alt text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Biztonsági rácsok</h4>
                <p class="text-gray-600 text-sm">Védőrácsok ablakokhoz és ajtókhoz</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-door-open text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Kapuk és kerítések</h4>
                <p class="text-gray-600 text-sm">Új gyártás és meglévők felújítása</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-industry text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Fémszerkezetek</h4>
                <p class="text-gray-600 text-sm">Vasszerkezetek és ipari megoldások</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">
            Tetszett valamelyik munkánk?
        </h2>
        <p class="text-xl mb-8 max-w-2xl mx-auto opacity-90">
            Vegye fel velünk a kapcsolatot, hogy az Ön projektje is ilyen minőségben készülhessen el!
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-envelope mr-2"></i>Kapcsolatfelvétel
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>