<!-- Hero szekció -->
<section class="relative h-screen flex items-center justify-center overflow-hidden">
    <!-- Háttérkép -->
    <div class="absolute inset-0 bg-cover bg-center bg-no-repeat" style="background-image: url('/assets/hero.jpg');">
        <div class="absolute inset-0 bg-black bg-opacity-50"></div>
    </div>
    
    <!-- Hero tartalom -->
    <div class="relative z-10 text-center text-white px-4 max-w-4xl mx-auto">
        <h1 class="text-5xl md:text-7xl font-bold mb-6 text-shadow animate-fade-in">
            Egyedi acélmunkák és<br>
            <span class="text-accent">professzionális lakatosmunkák</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 text-shadow opacity-90">
            Minőségi acélmegmunkálások és professzionális fémmunkák otthonokhoz és üzletekhez.<br>
            Évtizedes szakértelem, megbízható kivitelezés, tartós eredmények.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="/kapcsolat" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-arrow-down mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
    
    <!-- Scroll indicator -->
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
        <i class="fas fa-chevron-down text-white text-2xl opacity-70"></i>
    </div>
</section>

<!-- Fő szolgáltatások szekció -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Szakértő lakatosmunkák és fémszerkezetek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                A BDSTEEL – Lakatosmunkák minden fémmegmunkálási igényt kielégít. Lépcsőépítéstől a 
                fémszerkezetekig, biztonsági megoldásoktól a komplex ipari projektekig - minden munkát egyedi tervezéssel és precíz kivitelezéssel végzünk.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Lépcsőépítés -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-stairs text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Lépcsőépítés</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Egyedi lépcsőszerkezetek tervezése és kivitelezése beltérre és kültérre. 
                        Merész lépcsőtartók, modern korlátok és időjárásálló megoldások.
                    </p>
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Beltéri és kültéri lépcsők
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Egyedi lépcsőtartók
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Stílusos korlátok
                        </li>
                    </ul>
                    <a href="/lepcso-szerkezet-epitese" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                        Részletek <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
            
            <!-- Biztonsági rácsok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Biztonsági rácsok</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Egyedi tervezésű biztonsági rácsok ablakokhoz és ajtókhoz. 
                        Hatékony védelem az illetéktelen behatolás ellen, esztétikus kivitelezéssel.
                    </p>
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Ablak és ajtó rácsok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Egyedi méretek szerint
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Tartós anyagok
                        </li>
                    </ul>
                    <a href="/biztonsagi-racs-keszites" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                        Részletek <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
            
            <!-- Fémszerkezetek -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-industry text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Fémszerkezetek</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Komplex vasszerkezetek és ipari megoldások. Műhely berendezések, 
                        rakodó rámpák, acélszerkezetes építmények tervezése és kivitelezése.
                    </p>
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Vasszerkezet gyártás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Műhely berendezések
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check text-secondary mr-3"></i>
                            Rakodó rámpák
                        </li>
                    </ul>
                    <a href="/vasszerkezet-gyartas" class="inline-flex items-center text-secondary hover:text-secondary-dark font-semibold group-hover:translate-x-2 transition-transform duration-300">
                        Részletek <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szakértelem szekció -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Bal oldali kép -->
            <div class="relative">
                <div class="relative overflow-hidden rounded-3xl shadow-2xl transform hover:scale-105 transition-transform duration-500">
                    <img src="/assets/sec1.jpg" alt="Professzionális hegesztési munkák - BDSTEEL lakatosmunkák" 
                         class="w-full h-96 object-cover">
                    <div class="absolute inset-0 bg-gradient-to-tr from-secondary/20 to-transparent"></div>
                </div>
                <!-- Floating element -->
                <div class="absolute -bottom-6 -right-6 bg-accent rounded-2xl p-6 shadow-xl">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-tertiary">15+</div>
                        <div class="text-sm text-gray-600">Év tapasztalat</div>
                    </div>
                </div>
            </div>
            
            <!-- Jobb oldali tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Évtizedes szakértelem a <span class="text-secondary">lakatosmunkák</span> területén
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    A BDSTEEL – Lakatosmunkák szakemberei évek óta kiváló minőségű acélmunkákat és 
                    professzionális fémmegmunkálásokat készítenek a helyi közösség számára. 
                    Pontosságunk és megbízhatóságunk egyaránt kimagasló a fémipari munkák minden területén.
                </p>
                
                <div class="space-y-4">
                    <div class="flex items-center bg-gray-50 rounded-xl p-4 hover:bg-accent transition-colors duration-300">
                        <div class="bg-secondary rounded-lg p-3 mr-4">
                            <i class="fas fa-award text-white text-xl"></i>
                        </div>
                        <div>
                            <h4 class="font-semibold text-tertiary">Precíz munkavégzés</h4>
                            <p class="text-gray-600">Mesteri munka minden részletben, hosszú évekre tervezve</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center bg-gray-50 rounded-xl p-4 hover:bg-accent transition-colors duration-300">
                        <div class="bg-primary rounded-lg p-3 mr-4">
                            <i class="fas fa-gem text-white text-xl"></i>
                        </div>
                        <div>
                            <h4 class="font-semibold text-tertiary">Minőségi anyagok</h4>
                            <p class="text-gray-600">Csak a legjobb alapanyagok felhasználásával</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center bg-gray-50 rounded-xl p-4 hover:bg-accent transition-colors duration-300">
                        <div class="bg-tertiary rounded-lg p-3 mr-4">
                            <i class="fas fa-handshake text-white text-xl"></i>
                        </div>
                        <div>
                            <h4 class="font-semibold text-tertiary">Helyi megbízhatóság</h4>
                            <p class="text-gray-600">Évek óta bizonyított megbízhatóság a közösségben</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Komplex projektek szekció -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/30">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Bal oldali tartalom -->
            <div class="space-y-6 order-2 lg:order-1">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Komplex <span class="text-secondary">fémszerkezeti</span> megoldások
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    A BDSTEEL fémszerkezeti szakértelme lehetővé teszi a legösszetettebb projektek kivitelezését is. 
                    Kis léptékű egyedi megoldásoktól a nagyipari beruházásokig minden megrendelést 
                    szakmai alapossággal és megbízhatósággal teljesítünk.
                </p>
                
                <!-- Számok -->
                <div class="grid grid-cols-2 gap-6">
                    <div class="bg-white rounded-2xl p-6 text-center shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <div class="text-3xl font-bold text-secondary mb-2">500+</div>
                        <div class="text-gray-600">Sikeres projekt</div>
                    </div>
                    <div class="bg-white rounded-2xl p-6 text-center shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <div class="text-3xl font-bold text-primary mb-2">100%</div>
                        <div class="text-gray-600">Elégedett ügyfél</div>
                    </div>
                </div>
                
                <!-- CTA gomb -->
                <div class="pt-4">
                    <a href="/vasszerkezet-gyartas" class="inline-flex items-center bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                        <i class="fas fa-industry mr-3"></i>
                        Fémszerkezetek részletei
                        <i class="fas fa-arrow-right ml-3"></i>
                    </a>
                </div>
            </div>
            
            <!-- Jobb oldali kép -->
            <div class="relative order-1 lg:order-2">
                <div class="relative overflow-hidden rounded-3xl shadow-2xl transform hover:scale-105 transition-transform duration-500">
                    <img src="/assets/sec2.jpg" alt="Ipari fémszerkezetek és hegesztési munkák - BDSTEEL" 
                         class="w-full h-96 lg:h-[500px] object-cover">
                    <div class="absolute inset-0 bg-gradient-to-bl from-primary/20 to-transparent"></div>
                </div>
                <!-- Floating element -->
                <div class="absolute -top-6 -left-6 bg-white rounded-2xl p-6 shadow-xl">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-shield-alt text-secondary text-2xl"></i>
                        <div>
                            <div class="font-bold text-tertiary">Garancia</div>
                            <div class="text-sm text-gray-600">Minden munkára</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatások lista szekció -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Teljes körű lakatosmunkák és acélszerkezetek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden fémmegmunkálási igényt kielégítünk - a legkisebb javítástól a legnagyobb ipari projektekig
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-shield-alt text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Biztonsági rácsok</h4>
                <p class="text-gray-600 text-sm">Egyedi tervezésű rácsok ablakokhoz és ajtókhoz minden méretben</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-fence text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Kerítések és kapuk</h4>
                <p class="text-gray-600 text-sm">Új kerítések gyártása és meglévők szakszerű felújítása</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-stairs text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Lépcsőszerkezetek</h4>
                <p class="text-gray-600 text-sm">Beltéri és kültéri lépcsők egyedi tervezéssel és kivitelezéssel</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-hand-paper text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Korlátok</h4>
                <p class="text-gray-600 text-sm">Biztonságos és stílusos korlátok minden helyszínre</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-truck-loading text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Rakodó rámpák</h4>
                <p class="text-gray-600 text-sm">Ipari rakodó rámpák gyártása és szakszerű telepítése</p>
            </div>
            
            <div class="bg-gradient-to-br from-gray-50 to-accent/20 rounded-2xl p-6 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-toolbox text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Műhely berendezések</h4>
                <p class="text-gray-600 text-sm">Egyedi műhelyberendezések és tárolórendszerek gyártása</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 gradient-bg relative overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-20"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h2 class="text-4xl md:text-5xl font-bold mb-6 text-shadow">
            Kezdjük el közösen a projektjét!
        </h2>
        <p class="text-xl mb-8 max-w-2xl mx-auto opacity-90">
            Vegye fel velünk a kapcsolatot ingyenes konzultációért és árajánlatért. 
            Tapasztalt szakembereink segítenek megtalálni a legmegfelelőbb megoldást.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-envelope mr-2"></i>Kapcsolatfelvétel
            </a>
        </div>
    </div>
</section>

<style>
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    .animate-fade-in {
        animation: fade-in 1s ease-out;
    }
    
    /* Smooth scroll behavior */
    html {
        scroll-behavior: smooth;
    }
</style>