<?php
$page_title = 'Kapcsolat';
$page_description = 'Vegye fel a kapcsolatot a BDSTEEL csapatával - lakatosmunkák, lépcsőépítés és fémszerkezetek. Telefon: +36 70 609 6667. E-mail: bdsteel94@gmail.com';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Vegye fel velünk a <span class="text-accent">kapcsolatot</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            A BDSTEEL – Lakatosmunkák csapata készen áll minden lakatosmunkával, lépcsőépítéssel és 
            fémszerkezeti projekttel kapcsolatos kérdés megválaszolására.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:<?php echo $config['contact']['phone_raw']; ?>" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i><?php echo $config['contact']['phone']; ?>
            </a>
            <a href="mailto:<?php echo $config['contact']['email_main']; ?>" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-envelope mr-2"></i>E-mail küldése
            </a>
        </div>
    </div>
</section>

<!-- Elérhetőségek -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Elérhetőségeink</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Tapasztalt szakembereink szívesen segítenek a legmegfelelőbb megoldás kiválasztásában. 
                Minden megkeresésre gyorsan és alaposan válaszolunk.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-12 max-w-4xl mx-auto">
            <!-- Telefon -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8 text-center">
                    <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-phone text-white text-3xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Telefonos kapcsolat</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Hívjon bizalommal munkanapokon 8:00-17:00 között. 
                        Minden kérdésére szakértő válaszokat adunk és ingyenes tanácsadással segítünk.
                    </p>
                    <a href="tel:<?php echo $config['contact']['phone_raw']; ?>" class="inline-flex items-center bg-secondary hover:bg-secondary-dark text-white px-6 py-3 rounded-full font-semibold transition-all duration-300 transform hover:scale-105 mb-4">
                        <i class="fas fa-phone mr-2"></i>
                        <?php echo $config['contact']['phone']; ?>
                    </a>
                    <div class="mt-4 text-sm text-gray-500 space-y-2">
                        <p><i class="fas fa-clock mr-2"></i>Hétfő - Péntek: 8:00-17:00</p>
                        <p><i class="fas fa-calendar mr-2"></i>Hétvégén egyeztetés alapján</p>
                        <p><i class="fas fa-handshake mr-2"></i>Ingyenes telefonos tanácsadás</p>
                    </div>
                </div>
            </div>
            
            <!-- E-mail -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8 text-center">
                    <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-envelope text-white text-3xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">E-mail kapcsolat</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Írjon nekünk részletes leírással projektjéről, és 24 órán belül válaszolunk 
                        minden megkeresésre. E-mailben szívesen küldünk előzetes árajánlatot is.
                    </p>
                    <div class="space-y-3 mb-4">
                        <a href="mailto:<?php echo $config['contact']['email_main']; ?>" class="block bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-full font-semibold transition-all duration-300 transform hover:scale-105 text-sm">
                            <i class="fas fa-envelope mr-2"></i>
                            <?php echo $config['contact']['email_main']; ?>
                        </a>
                        <a href="mailto:<?php echo $config['contact']['email_support']; ?>" class="block bg-tertiary hover:bg-tertiary-dark text-white px-4 py-2 rounded-full font-semibold transition-all duration-300 transform hover:scale-105 text-sm">
                            <i class="fas fa-headset mr-2"></i>
                            <?php echo $config['contact']['email_support']; ?>
                        </a>
                    </div>
                    <div class="mt-4 text-sm text-gray-500 space-y-2">
                        <p><i class="fas fa-reply mr-2"></i>Válasz: 24 órán belül</p>
                        <p><i class="fas fa-calculator mr-2"></i>Ingyenes árajánlat</p>
                        <p><i class="fas fa-images mr-2"></i>Képek csatolhatók</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Árajánlat kérés -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Árajánlat kérés és <span class="text-secondary">konzultáció</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Minden projekt ingyenes konzultációval és egyedi árajánlattal kezdődik. Helyszíni felmérés során 
                    pontosan felmérjük az igényeket, a technikai lehetőségeket és a legoptimálisabb megoldási módokat.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-calculator text-secondary mr-3"></i>
                            Ingyenes árajánlat
                        </h4>
                        <p class="text-gray-600">Részletes költségkalkuláció minden projektre előzetesen</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-map-marked-alt text-secondary mr-3"></i>
                            Helyszíni felmérés
                        </h4>
                        <p class="text-gray-600">Pontos méretek és technikai lehetőségek felmérése</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-lightbulb text-secondary mr-3"></i>
                            Szakmai tanácsadás
                        </h4>
                        <p class="text-gray-600">Tapasztalt szakembereink segítenek a legjobb megoldás kiválasztásában</p>
                    </div>
                </div>
            </div>
            
            <!-- Szolgáltatási infók -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Mit kínálunk?</h3>
                
                <div class="space-y-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-center">
                            <i class="fas fa-stairs text-secondary text-xl mr-4"></i>
                            <div>
                                <h5 class="font-semibold text-tertiary">Lépcsőépítés</h5>
                                <p class="text-sm text-gray-600">Beltéri és kültéri lépcsőszerkezetek</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-center">
                            <i class="fas fa-shield-alt text-secondary text-xl mr-4"></i>
                            <div>
                                <h5 class="font-semibold text-tertiary">Biztonsági rácsok</h5>
                                <p class="text-sm text-gray-600">Egyedi rácsok ablakokhoz és ajtókhoz</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-center">
                            <i class="fas fa-industry text-secondary text-xl mr-4"></i>
                            <div>
                                <h5 class="font-semibold text-tertiary">Fémszerkezetek</h5>
                                <p class="text-sm text-gray-600">Vasszerkezetek, ipari megoldások</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-center">
                            <i class="fas fa-handshake text-secondary text-xl mr-4"></i>
                            <div>
                                <h5 class="font-semibold text-tertiary">Garancia</h5>
                                <p class="text-sm text-gray-600">Teljes körű garanciavállalás</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatási terület -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Szolgáltatási területünk</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Elsősorban Budapest és vonzáskörzetében vállalunk munkákat, de nagyobb projektek esetén 
                az ország egész területén dolgozunk
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-map-marker-alt text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Budapest</h4>
                <p class="text-gray-600 text-sm">Minden kerületben vállalunk munkát</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-home text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Pest megye</h4>
                <p class="text-gray-600 text-sm">Agglomeráció és környező települések</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-truck text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Nagyobb projektek</h4>
                <p class="text-gray-600 text-sm">Országosan vállaljuk komplex munkákat</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-clock text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Gyors kiszállás</h4>
                <p class="text-gray-600 text-sm">Budapesten belül rugalmas időpontok</p>
            </div>
        </div>
    </div>
</section>

<!-- Miért válassza a BDSTEEL-t -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Miért válassza a BDSTEEL-t?</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Ahol a minőség és a megbízhatóság találkozik - évtizedes tapasztalat a szolgálatában
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-medal text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Évtizedes tapasztalat</h3>
                <p class="text-gray-600">Lépcsőépítés, biztonsági rácsok és fémszerkezetek területén szerzett szakértelem</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-gem text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Minőségi anyagok</h3>
                <p class="text-gray-600">Csak a legmagasabb minőségű alapanyagokat és modern technológiákat használjuk</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-handshake text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Megbízhatóság</h3>
                <p class="text-gray-600">Pontos munkavégzés és a megbeszélt határidők betartása minden projektnél</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-euro-sign text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Versenyképes árak</h3>
                <p class="text-gray-600">Átlátható költségkalkuláció és versenyképes árazás minden projektnél</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-primary w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-clock text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Rugalmas időpontok</h3>
                <p class="text-gray-600">Egyeztetés alapján hétvégén is elérhetők vagyunk</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-tertiary w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-shield-alt text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Teljes garancia</h3>
                <p class="text-gray-600">Komplett garanciavállalás minden elvégzett munkára</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">
            Kezdjük el közösen a projektjét!
        </h2>
        <p class="text-xl mb-8 max-w-2xl mx-auto opacity-90">
            Ne habozzon, vegye fel velünk a kapcsolatot még ma! Ingyenes konzultáció és árajánlat minden megkeresésre.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:<?php echo $config['contact']['phone_raw']; ?>" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i><?php echo $config['contact']['phone']; ?>
            </a>
            <a href="mailto:<?php echo $config['contact']['email_main']; ?>" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-envelope mr-2"></i>E-mail küldése
            </a>
        </div>
        
        <!-- Gyors elérhetőségek -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-16 pt-16 border-t border-white/20 max-w-2xl mx-auto">
            <div class="text-center">
                <i class="fas fa-phone text-accent text-3xl mb-4"></i>
                <h4 class="font-bold mb-2">Telefonos segítség</h4>
                <p class="opacity-90"><?php echo $config['contact']['phone']; ?></p>
                <p class="text-sm opacity-75">H-P: 8:00-17:00</p>
            </div>
            <div class="text-center">
                <i class="fas fa-envelope text-accent text-3xl mb-4"></i>
                <h4 class="font-bold mb-2">E-mail válasz 24h</h4>
                <p class="opacity-90"><?php echo $config['contact']['email_main']; ?></p>
                <p class="text-sm opacity-75">Gyors válaszadás garantálva</p>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>