<?php
$page_title = 'Kapuk és Kerítések Felújítása';
$page_description = 'Meglévő kapuk és kerítések szakszerű felújítása Budapesten - javítás, átalakítás, festés, hegesztés. BDSTEEL professzionális felújítási szolgáltatások minden típusú kerítéshez és kapuhoz.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-tertiary via-primary to-secondary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Kapuk és Kerítések <span class="text-accent">Felújítása</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Régi kapuk és kerítések teljes körű felújítása, javítása és átalakítása. Szolgáltatásunk keretében 
            vállaljuk kapuk és kerítések állapotának javítását, hogy újra megbízhatóan és esztétikusan szolgálják otthonát.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Gyorsjavítás
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-wrench mr-2"></i>Felújítási szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Főbb felújítási szolgáltatások -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Teljes körű felújítási szolgáltatások</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Legyen szó egyszerű javításról vagy egy teljesen új kialakításról, profi megoldásokat kínálunk. 
                Minden felújítási munkát szakértelemmel és precizitással végzünk.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Kapuk felújítása -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-door-open text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Régi kapuk felújítása</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Vállaljuk régi kapuk állapotának teljes körű javítását vagy akár teljes átalakítását, 
                        hogy újra megbízhatóan és esztétikusan szolgálják otthonát.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Teljes körű javítás és átalakítás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Megbízható és esztétikus eredmény
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyszerű javítástól teljes felújításig
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Profi megoldások minden igényre
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-tools mr-2"></i>
                            Minden kapufelújítás egyedi felmérés alapján, a legmegfelelőbb technikával
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Mechanikai javítások -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-cogs text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Kapuk mechanikai javításai</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Megoldjuk a kapuk mechanikai problémáit: csavarozás, rögzítés szakszerű javítása, 
                        hogy kapuja stabil és biztonságos legyen. Minden apró alkatrész helyreállítását precízen végezzük.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Csavarozás és rögzítés javítása
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Stabil és biztonságos eredmény
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Apró alkatrészek precíz helyreállítása
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Mechanikai problémák szakszerű megoldása
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-wrench mr-2"></i>
                            Minden mechanikai javítás tartós megoldásokkal és minőségi alkatrészekkel
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Hegesztéses javítások -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Helyszíni <span class="text-secondary">hegesztéses javítások</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Sérült fém elemeket gyors és tartós megoldással, helyszíni hegesztéssel állítjuk helyre, 
                    ezzel jelentősen megnövelve kapuja élettartamát. Minden javítás szakszerűen és tartósan történik.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-fire text-secondary mr-3"></i>
                            Gyors hegesztéses javítások
                        </h4>
                        <p class="text-gray-600">Helyszíni hegesztéssel sérült fém elemek azonnali helyreállítása</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Tartós megoldások
                        </h4>
                        <p class="text-gray-600">Minden javítás hosszú távú stabilitást és megbízhatóságot biztosít</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-clock text-secondary mr-3"></i>
                            Élettartam növelése
                        </h4>
                        <p class="text-gray-600">Szakszerű javítással jelentősen megnöveljük a konstrukció élettartamát</p>
                    </div>
                </div>
            </div>
            
            <!-- Hegesztés előnyei -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Hegesztéses javítás előnyei</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-bolt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Gyors megoldás</h5>
                        <p class="text-sm text-gray-600">Helyszíni munkavégzés, azonnali eredmény</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-hammer text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Erős kapcsolat</h5>
                        <p class="text-sm text-gray-600">Tartós és stabil hegesztett kötések</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-euro-sign text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Költséghatékony</h5>
                        <p class="text-sm text-gray-600">Olcsóbb, mint a teljes csere</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-leaf text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Környezetbarát</h5>
                        <p class="text-sm text-gray-600">Javítás cserével szemben</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Kerítések felújítása -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Kerítések teljes körű felújítása</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Komplex szolgáltatásunk magában foglalja a kerítések teljes körű felújítását is, 
                beleértve a sérült elemek cseréjét, újrafestést vagy szükség szerinti átalakítást.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Fém kerítések felújítása -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-industry text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Fém kerítések</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Acél és vas kerítések felújítása: rozsdásodás eltávolítása, sérült elemek cseréje, 
                        újra horganyzás vagy festés a tartós védelem érdekében.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Rozsdásodás eltávolítása</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Sérült elemek cseréje</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Újra horganyzás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Védő festés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Deszkakerítés felújítása -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-tree text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Deszkakerítés felújítása</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Vállaljuk a fa deszkakerítések felületének teljes felújítását: csiszolás, festés, lakkozás, 
                        hogy kerítése hosszú ideig megőrizze szépségét és védelmét az időjárással szemben.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Felület csiszolása</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Védő festés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Lakkozás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Időjárás elleni védelem</li>
                    </ul>
                </div>
            </div>
            
            <!-- Kombinált kerítések -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-puzzle-piece text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Kombinált megoldások</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Fém és fa elemeket tartalmazó kerítések komplex felújítása, 
                        ahol minden anyaghoz a megfelelő technikát alkalmazzuk.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Anyag-specifikus kezelés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Komplex felújítás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Harmonikus eredmény</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Hosszú távú védelem</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Felújítási folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Bízza ránk kerítése gondozását</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Professzionális felújítási folyamattal gondoskodunk róla, hogy kerítése újra megbízható és látványos legyen
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Állapotfelmérés</h3>
                <p class="text-gray-600">Részletes vizsgálat a sérülések és a szükséges javítások meghatározásához</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Javítási terv</h3>
                <p class="text-gray-600">Egyedi felújítási terv készítése a legoptimálisabb megoldásokkal</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szakszerű kivitelezés</h3>
                <p class="text-gray-600">Minden felújítási munka precíz és tartós megoldásokkal</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Minőségellenőrzés</h3>
                <p class="text-gray-600">Teljes körű ellenőrzés és átvétel garanciával</p>
            </div>
        </div>
    </div>
</section>

<!-- Felújítás előnyei -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Miért érdemes felújítani?</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                A felújítás sokszor gazdaságosabb megoldás, mint a teljes csere, és környezetbarát is
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-euro-sign text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Költséghatékony</h3>
                <p class="opacity-90">Sokszor olcsóbb, mint a teljes csere</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-leaf text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Környezetbarát</h3>
                <p class="opacity-90">Kevesebb hulladék keletkezik</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-clock text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Gyors megoldás</h3>
                <p class="opacity-90">Rövidebb határidő, mint új építés</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-heart text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Eredeti karakter</h3>
                <p class="opacity-90">Megőrzi az eredeti stílust és hangulatot</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Újítsa fel kapuját és kerítését velünk!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes állapotfelméréséért és árajánlatért. 
            Minden felújítás egyedi igények szerint, szakértő kivitelezéssel.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-wrench mr-2"></i>Állapotfelmérés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>