<?php
$page_title = 'Kerítések és Kapuk Gyártása';
$page_description = 'Egyedi kerítések és kapuk gyártása Budapesten - fém, fa és kombinált megoldások. BDSTEEL professzionális kerítés- és kapugyártás egyedi igények szerint, gyors határidőkkel.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Kerítések és Kapuk <span class="text-accent">Gyártása</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Egyedi igényekre szabva. Vállaljuk egyedi kerítések és kapuk gyártását, amelyek tökéletesen 
            illeszkednek otthona stílusához és funkcionális elvárásaihoz. Minden kapu és kerítés precíz kidolgozással készül.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Tervezés és konzultáció
            </a>
            <a href="#anyagvalasztek" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-hammer mr-2"></i>Anyagválaszték
            </a>
        </div>
    </div>
</section>

<!-- Egyedi gyártás -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Egyedi kerítések és kapuk minden igényre</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden kapu és kerítés precíz kidolgozással, magas szakmai színvonalon készül, 
                garantálva a hosszú élettartamot és a megbízható védelmet.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Precíz kidolgozás -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-drafting-compass text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Precíz kidolgozás</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Minden kapu és kerítés precíz kidolgozással, magas szakmai színvonalon készül, 
                        garantálva a hosszú élettartamot és a megbízható védelmet minden körülmény között.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Magas szakmai színvonal
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Hosszú élettartam garancia
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Megbízható védelem
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Minden körülményben stabil
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-award mr-2"></i>
                            Minden termék a legmagasabb minőségi standardok szerint készül
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Stílus és funkció -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-palette text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Stílus és funkció harmóniája</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Legyen szó klasszikus, modern vagy rusztikus megjelenésről, mi a legapróbb részletekre is figyelünk, 
                        hogy a végeredmény egyszerre legyen esztétikus és funkcionális.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Klasszikus megjelenés
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Modern dizájn
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Rusztikus stílus
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Esztétikus és funkcionális
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-eye mr-2"></i>
                            Figyelünk a legapróbb részletekre is a tökéletes eredményért
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Anyagválaszték -->
<section id="anyagvalasztek" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Széles anyagválaszték</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Széles anyagválasztékból dolgozunk, beleértve a tartós fémet, természetes fát, valamint ezek kombinációját, 
                így minden ügyfelünk megtalálja a számára ideális megoldást.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Tartós fém -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="text-center mb-6">
                    <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-hammer text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Tartós fém megoldások</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed text-center">
                    Kiváló minőségű acél és alumínium anyagok, amelyek hosszú távú stabilitást 
                    és megbízhatóságot garantálnak minden időjárási körülmény között.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Acél kerítések és kapuk
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Alumínium konstrukciók
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Korrózióálló felületkezelés
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Időjárásálló kivitelezés
                    </li>
                </ul>
            </div>
            
            <!-- Természetes fa -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="text-center mb-6">
                    <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-tree text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Természetes fa</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed text-center">
                    Válogatott fafajok természetes melegséggel és otthonos hangulattal. 
                    Megfelelő impregnálással és felületkezeléssel a tartósság érdekében.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Válogatott fafajok
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Természetes megjelenés
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Megfelelő impregnálás
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Otthonos hangulat
                    </li>
                </ul>
            </div>
            
            <!-- Kombinált megoldások -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="text-center mb-6">
                    <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-puzzle-piece text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Kombinált megoldások</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed text-center">
                    Fém és fa anyagok harmonikus ötvözése egyedi és látványos megjelenésért. 
                    A két anyag előnyeinek optimális kihasználása.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Fém-fa kombináció
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Harmonikus megjelenés
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Egyedi dizájn
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Optimális előnyök
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Teljes körű szolgáltatás -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Tervezéstől a <span class="text-secondary">beépítésig</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Számíthat ránk a tervezéstől egészen a beépítésig, gyors határidőkkel és rugalmas megoldásokkal. 
                    Bízza ránk kapuja és kerítése gyártását, hogy otthona ne csak biztonságos, de stílusos is legyen!
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-drafting-compass text-secondary mr-3"></i>
                            Egyedi tervezés
                        </h4>
                        <p class="text-gray-600">Személyre szabott tervezés az Ön igényei és elképzelései szerint</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-clock text-secondary mr-3"></i>
                            Gyors határidők
                        </h4>
                        <p class="text-gray-600">Hatékony munkaszervezéssel rövid átfutási idők</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-tools text-secondary mr-3"></i>
                            Rugalmas megoldások
                        </h4>
                        <p class="text-gray-600">Alkalmazkodunk az egyedi igényekhez és helyszíni adottságokhoz</p>
                    </div>
                </div>
            </div>
            
            <!-- Szolgáltatások -->
            <div class="bg-white rounded-3xl p-8 shadow-xl">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Teljes körű szolgáltatás</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-pencil-ruler text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Tervezés</h5>
                            <p class="text-sm text-gray-600">Egyedi tervek készítése 3D vizualizációval</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-industry text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Gyártás</h5>
                            <p class="text-sm text-gray-600">Precíz műhelyi kivitelezés minőségi anyagokból</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-truck text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Szállítás</h5>
                            <p class="text-sm text-gray-600">Biztonságos szállítás a helyszínre</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-hammer text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Beépítés</h5>
                            <p class="text-sm text-gray-600">Szakszerű telepítés és beüzemelés</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Kerítés és kapu típusok -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Biztonságos és stílusos megoldások</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden általunk gyártott kerítés és kapu egyedi tervezésű, hogy tökéletesen illeszkedjen 
                otthona stílusához és biztonsági igényeihez
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Klasszikus kerítések -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-2xl p-6 text-center hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-home text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Klasszikus kerítések</h4>
                <p class="text-gray-600 text-sm">Hagyományos megjelenésű kerítések időtálló dizájnnal</p>
            </div>
            
            <!-- Modern kapuk -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-2xl p-6 text-center hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-door-open text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Modern kapuk</h4>
                <p class="text-gray-600 text-sm">Kortárs design és újszerű megoldások</p>
            </div>
            
            <!-- Rusztikus stílus -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-2xl p-6 text-center hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-tree text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Rusztikus stílus</h4>
                <p class="text-gray-600 text-sm">Természetes anyagok és vidéki hangulat</p>
            </div>
            
            <!-- Egyedi megoldások -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-2xl p-6 text-center hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                <i class="fas fa-puzzle-piece text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Egyedi megoldások</h4>
                <p class="text-gray-600 text-sm">Teljesen személyre szabott tervezés</p>
            </div>
        </div>
    </div>
</section>

<!-- Gyártási folyamat -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Gyártási folyamatunk</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Minden lépésben a minőségre és a precizitásra összpontosítunk, hogy az eredmény hosszú távon is kifogástalan legyen
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">1</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Konzultáció</h3>
                <p class="opacity-90">Igények felmérése és egyedi tervezési konzultáció</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">2</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Tervezés</h3>
                <p class="opacity-90">Részletes tervek és 3D vizualizáció készítése</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">3</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Gyártás</h3>
                <p class="opacity-90">Precíz műhelyi kivitelezés és minőségellenőrzés</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Telepítés</h3>
                <p class="opacity-90">Szakszerű beépítés és végleges beüzemelés</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Készíttesse el egyedi kerítését és kapuját velünk!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes konzultációért és tervezésért. 
            Minden kerítés és kapu egyedi igények szerint, a legapróbb részletekre figyelve készül.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-drafting-compass mr-2"></i>Tervezési konzultáció
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>