<?php
$page_title = 'Korlátok Kivitelezése';
$page_description = 'Egyedi korlátok tervezése és kivitelezése beltéri és kültéri helyszínekre Budapesten - acél, rozsdamentes acél, alumínium és fa korlátok. BDSTEEL professzionális korlátkivitelezés.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            <span class="text-accent">Korlátok</span> Kivitelezése
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Biztonság és stílus minden helyszínre. Egyedi korlátok tervezése és kivitelezése beltéri és kültéri 
            helyszínekre egyaránt. Megbízható, tartós és esztétikus megoldások lépcsőkre, erkélyekre, teraszokra és galériákra.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Műszaki tanácsadás
            </a>
            <a href="#anyagok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-shield-alt mr-2"></i>Anyagválaszték
            </a>
        </div>
    </div>
</section>

<!-- Korlát típusok és helyszínek -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Korlátok minden helyszínre</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Vállaljuk egyedi korlátok tervezését és kivitelezését beltéri és kültéri helyszínekre egyaránt. 
                Legyen szó lépcsőkről, erkélyekről, teraszokról vagy galériákról.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Lépcsőkorlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-6 text-center">
                    <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-stairs text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Lépcsőkorlátok</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Biztonságos és stílusos lépcsőkorlátok beltéri és kültéri lépcsőkhöz. 
                        Egyedi igények szerint tervezve és kivitelezve.
                    </p>
                </div>
            </div>
            
            <!-- Erkélykorlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-6 text-center">
                    <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-building text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Erkélykorlátok</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Időjárásálló erkélykorlátok minden stílusban. Tartós anyagok 
                        és szakszerű kivitelezés garantálja a hosszú élettartamot.
                    </p>
                </div>
            </div>
            
            <!-- Teraszkorlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-6 text-center">
                    <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-umbrella-beach text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Teraszkorlátok</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Elegáns teraszkorlátok, amelyek harmonikusan illeszkednek 
                        a kültéri környezetbe és fokozzák a terasz hangulatát.
                    </p>
                </div>
            </div>
            
            <!-- Galériakorlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-6 text-center">
                    <div class="bg-gradient-to-br from-accent to-accent-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-home text-tertiary text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Galériakorlátok</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Beltéri galériák és szintkülönbségek biztonságos elhatárolása 
                        esztétikus és funkcionális korlátmegoldásokkal.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Anyagválaszték -->
<section id="anyagok" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Anyagválaszték és kivitelezés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Acél, rozsdamentes acél, alumínium és fa korlátok gyártása és telepítése. 
                Minden anyag kiváló minőségű és a legmagasabb követelményeknek megfelelő.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Acél korlátok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="flex items-center mb-6">
                    <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                        <i class="fas fa-hammer text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Acél korlátok</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Tartós és erős acél korlátok, amelyek kiválóan alkalmasak minden típusú épülethez. 
                    Speciális felületkezeléssel védve a korrózió ellen.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Nagy teherbírású konstrukció
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Költséghatékony megoldás
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Egyedi formázási lehetőségek
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Horganyzás és festési opciók
                    </li>
                </ul>
            </div>
            
            <!-- Rozsdamentes acél korlátok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="flex items-center mb-6">
                    <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                        <i class="fas fa-gem text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Rozsdamentes acél korlátok</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Prémium minőségű rozsdamentes acél korlátok, amelyek tökéletesek modern épületekhez 
                    és különösen ajánlottak kültéri alkalmazásokhoz.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Teljes korrózióállóság
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Modern, elegáns megjelenés
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Minimális karbantartási igény
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Hosszú élettartam
                    </li>
                </ul>
            </div>
            
            <!-- Alumínium korlátok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="flex items-center mb-6">
                    <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                        <i class="fas fa-feather text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Alumínium korlátok</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Könnyű, de erős alumínium korlátok, amelyek ideálisak olyan helyekre, 
                    ahol a súly fontos szempont, de nem akarunk lemondani a tartósságról.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Könnyű szerkezet
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Természetes korrózióállóság
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Könnyű szerelhetőség
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Újrahasznosítható anyag
                    </li>
                </ul>
            </div>
            
            <!-- Fa korlátok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="flex items-center mb-6">
                    <div class="bg-gradient-to-br from-accent to-accent-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                        <i class="fas fa-tree text-tertiary text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary">Fa korlátok</h3>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Természetes fa korlátok, amelyek meleg és otthonos hangulatot teremtenek. 
                    Kiváló minőségű fafajokból, megfelelő impregnálással és felületkezeléssel.
                </p>
                <ul class="space-y-3">
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Természetes, meleg megjelenés
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Környezetbarát anyag
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Egyedi megmunkálási lehetőségek
                    </li>
                    <li class="flex items-center text-gray-600">
                        <i class="fas fa-check-circle text-secondary mr-3"></i>
                        Megfelelő impregnálással védett
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Felületkezelés és tartósság -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Felületkezelés a <span class="text-secondary">hosszú élettartamért</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Felületkezelés: horganyzás, porszórás, festés a hosszú élettartam érdekében. 
                    Minden korlátnál kiemelt figyelmet fordítunk a tartósságra és az időjárási hatásokkal szembeni ellenállásra.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Horganyzás
                        </h4>
                        <p class="text-gray-600">Kiváló korrózióvédelem acél korlátoknak, évtizedes tartósság</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-spray-can text-secondary mr-3"></i>
                            Porszórás
                        </h4>
                        <p class="text-gray-600">Egyenletes, tartós felületvédelem széles színválasztékkal</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-palette text-secondary mr-3"></i>
                            Festés
                        </h4>
                        <p class="text-gray-600">Speciális külső festékekkel az időjárásállóság és színtartósság érdekében</p>
                    </div>
                </div>
            </div>
            
            <!-- Előnyök -->
            <div class="bg-white rounded-3xl p-8 shadow-xl">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Korlátaink előnyei</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-shield-alt text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Biztonság</h5>
                            <p class="text-sm text-gray-600">Megbízható védelem minden körülmény között</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-eye text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Esztétikum</h5>
                            <p class="text-sm text-gray-600">Harmonikus illeszkedés az épület stílusához</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-clock text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Tartósság</h5>
                            <p class="text-sm text-gray-600">Hosszú élettartam megfelelő karbantartással</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-tools text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Könnyű karbantartás</h5>
                            <p class="text-sm text-gray-600">Minimális gondozási igény</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatási folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Gyors és precíz helyszíni szerelés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Műszaki tanácsadás és helyszíni felmérés után gyors és precíz telepítéssel gondoskodunk róla, 
                hogy korlátjai tökéletesen illeszkedjenek és maximális biztonságot nyújtsanak.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Műszaki tanácsadás</h3>
                <p class="text-gray-600">Szakértői konzultáció és igények felmérése a legmegfelelőbb megoldás kiválasztásához</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Helyszíni felmérés</h3>
                <p class="text-gray-600">Pontos méretek felvétele és a helyszín adottságainak szakértői vizsgálata</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Egyedi gyártás</h3>
                <p class="text-gray-600">Precíz műhelyi gyártás a felmért méretek és egyedi igények alapján</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szakszerű telepítés</h3>
                <p class="text-gray-600">Gyors és precíz helyszíni szerelés minden biztonsági előírás betartásával</p>
            </div>
        </div>
    </div>
</section>

<!-- Harmonikus megjelenés -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Harmonikus illeszkedés</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Korlátaink nemcsak biztonságot nyújtanak, hanem hozzájárulnak az épület harmonikus megjelenéséhez is. 
                Bízza ránk a kivitelezést, hogy megvalósítsuk elképzeléseit!
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-palette text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Egyedi tervezés</h3>
                <p class="opacity-90">Minden korlát az épület stílusához és környezetéhez igazítva</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-home text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Otthonos hangulat</h3>
                <p class="opacity-90">Meleg és befogadó környezet teremtése megfelelő anyagválasztással</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-award text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Kiváló minőség</h3>
                <p class="opacity-90">Csak a legjobb anyagokból és szakértő kivitelezéssel</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Tervezze meg egyedi korlátját velünk!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot műszaki tanácsadásért és helyszíni felméréséért. 
            Minden korlát egyedi igények szerint tervezve és kivitelezve.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-calendar mr-2"></i>Helyszíni felmérés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>