<?php
$page_title = 'Lakatosmunkák';
$page_description = 'Professzionális lakatosmunkák Budapesten - ajtózárak, biztonsági rácsok, kerítések, kapuk automatizálása. BDSTEEL évtizedes tapasztalat a lakatosipari munkák területén.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Professzionális <span class="text-accent">Lakatosmunkák</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Évtizedes tapasztalattal rendelkezünk a lakatosmunkák legszélesebb spektrumában. 
            Specializálódtunk mind a hagyományos lakatosipari feladatokra, mind a modern acélmegmunkálási technológiákra.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Azonnali segítség
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-tools mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Főbb lakatosmunkák -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Lakatosmunkák szolgáltatásaink</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                A BDSTEEL – Lakatosmunkák csapata minden lakatosipari igényt kielégít. 
                Precíz munkavégzés, megbízható kivitelezés és hosszú távú garancia minden projektnél.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Ajtózárak és biztonsági megoldások -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-lock text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ajtózárak és biztonsági megoldások</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Professzionális ajtózár szerelés, javítás és cserék minden típusú ajtóhoz. 
                        Biztonsági zárak telepítése, kulcsmásolás és vészhelyzeti zárnyitás szolgáltatás.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ajtózár szerelés és javítás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Biztonsági zárak telepítése
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Vészhelyzeti zárnyitás 24/7
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Kulcsmásolás és átkulcsolás
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-shield-alt mr-2"></i>
                            Minden lakatosmunka garanciával és azonnali elérhetőséggel
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Biztonsági rácsok -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-shield-alt text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Biztonsági rács készítés</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Egyedi tervezésű biztonsági rácsok ablakokhoz és ajtókhoz. 
                        Minden biztonsági rács az egyedi méretek szerint készül, biztosítva a tökéletes illeszkedést.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyedi méretek szerint
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Tartós anyagok használata
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Korszerű rögzítési technológiák
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ablak és ajtó rácsok
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-ruler mr-2"></i>
                            Helyszíni felmérés és egyedi tervezés minden projekt esetén
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Kerítések és kapuk -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Kerítések és <span class="text-secondary">kapuk</span> szakértő kivitelezése
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Komplett kerítés és kapu megoldások tervezésétől a kivitelezésig. 
                    Új kerítések és kapuk gyártása, meglévő kerítések felújítása és megerősítése. 
                    Minden kapu automatizálási lehetőséggel is bővíthető.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-hammer text-secondary mr-3"></i>
                            Új kerítések és kapuk gyártása
                        </h4>
                        <p class="text-gray-600">Egyedi tervezésű kerítések és kapuk minden stílusban és méretben</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-wrench text-secondary mr-3"></i>
                            Meglévő kerítések felújítása
                        </h4>
                        <p class="text-gray-600">Régi kerítések és kapuk felújítása, megerősítése és modernizálása</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-cog text-secondary mr-3"></i>
                            Kapuk automatizálása
                        </h4>
                        <p class="text-gray-600">Modern automatizálási rendszerek telepítése új és meglévő kapukhoz</p>
                    </div>
                </div>
            </div>
            
            <!-- Kerítés típusok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Kerítés és kapu típusaink</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-fence text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Hagyományos kerítések</h5>
                        <p class="text-sm text-gray-600">Klasszikus fém kerítések tartós kivitelben</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-door-open text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Modern kapuk</h5>
                        <p class="text-sm text-gray-600">Kortárs design és funkcionalitás</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-shield-alt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Biztonsági kerítések</h5>
                        <p class="text-sm text-gray-600">Fokozott biztonságú megoldások</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-robot text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Automatizált kapuk</h5>
                        <p class="text-sm text-gray-600">Távirányítós és okos vezérlés</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Speciális lakatosmunkák -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Speciális lakatosmunkák</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Egyedi igények kielégítése speciális lakatosipari megoldásokkal
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Rakodó rámpák -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-truck-loading text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Rakodó rámpák</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Ipari és kereskedelmi célú rakodó rámpák tervezése és kivitelezése. 
                        Minden rámpa az egyedi terhelési követelményekhez igazítva készül.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Egyedi teherbírás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Biztonságos kialakítás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tartós konstrukció</li>
                    </ul>
                </div>
            </div>
            
            <!-- Műhely berendezések -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-toolbox text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Műhely berendezések</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Egyedi műhelyberendezések, munkaasztalok, tárolórendszerek és ipari bútorok készítése. 
                        Minden berendezés a konkrét munkavégzési igényekhez optimalizálva.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Munkaasztalok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tárolórendszerek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Ipari bútorok</li>
                    </ul>
                </div>
            </div>
            
            <!-- Egyedi megoldások -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-puzzle-piece text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Egyedi megoldások</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Speciális lakatosipari igények kielégítése egyedi tervezéssel és kivitelezéssel. 
                        Minden projekt egyedi megközelítést kap.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Egyedi tervezés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Speciális anyagok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Komplex megoldások</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lakatosmunkák előnyei -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Miért válassza a BDSTEEL lakatosmunkáit?</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                A BDSTEEL – Lakatosmunkák név garancia a precíz munkavégzésre és a hosszú távú megbízhatóságra
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-medal text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szakértelem</h3>
                <p class="text-gray-600">Évtizedes tapasztalat minden lakatosipari munkában</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-clock text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Gyorsaság</h3>
                <p class="text-gray-600">Rugalmas időbeosztás és gyors kivitelezés</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-handshake text-white text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Megbízhatóság</h3>
                <p class="text-gray-600">Pontos munkavégzés és határidők betartása</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <i class="fas fa-shield-alt text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Garancia</h3>
                <p class="text-gray-600">Teljes körű garanciavállalás minden munkára</p>
            </div>
        </div>
    </div>
</section>

<!-- Folyamat szekció -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Lakatosmunkák folyamata</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Minden lakatosmunka során ugyanazt a bevált folyamatot követjük a tökéletes eredmény érdekében
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">1</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Konzultáció</h3>
                <p class="opacity-90">Részletes igényfelmérés és tanácsadás telefonon vagy helyszínen</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">2</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Felmérés</h3>
                <p class="opacity-90">Helyszíni felmérés és pontos méretek felvétele</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">3</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Kivitelezés</h3>
                <p class="opacity-90">Professzionális munkavégzés minőségi anyagokkal</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold mb-4">Átadás</h3>
                <p class="opacity-90">Munka átadása garanciával és karbantartási tanácsokkal</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Kérjen árajánlatot lakatosmunkáinkra!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes konzultációért és részletes árajánlatért. 
            Minden lakatosmunka egyedi igények szerint, precíz kivitelezéssel.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>E-mail küldése
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-map-marker-alt mr-2"></i>Kapcsolat
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>