<?php
$page_title = 'Lépcső Szerkezet Építése';
$page_description = 'Egyedi lépcsőszerkezetek építése kültérre és beltérre Budapesten - acél, alumínium, fa és kombinált megoldások. BDSTEEL professzionális lépcső tervezés és kivitelezés.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-secondary via-primary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            <span class="text-accent">Lépcső Szerkezet</span> Építése
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Biztonságos és esztétikus lépcsőszerkezetek tervezése és kivitelezése kültéri és beltéri használatra egyaránt. 
            Egyedi megoldások széles anyagválasztékkal minden stílushoz és funkcionális igényhez.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Helyszíni felmérés
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-stairs mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Főbb szolgáltatások -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Lépcsőszerkezet építési szolgáltatásaink</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Vállaljuk egyedi lépcsőszerkezetek tervezését és kivitelezését kültéri és beltéri használatra egyaránt. 
                Minden projekt személyre szabott tervezéssel és precíz kivitelezéssel valósul meg.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Beltéri lépcsőszerkezetek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-home text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Beltéri lépcsőszerkezetek</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Stabil, biztonságos lépcsőszerkezetek gyártása és beépítése lakóházakba, irodaépületekbe. 
                        Modern és klasszikus dizájnok megvalósítása a tér stílusához igazítva.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Családi házak számára
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Irodaépületek részére
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Modern és klasszikus dizájnok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Személyre szabott tervezés
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-ruler mr-2"></i>
                            Helyszíni felmérés és személyre szabott tervezés minden projektnél
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Kültéri lépcsőszerkezetek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-tree text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Kültéri lépcsőszerkezetek</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Időjárásálló lépcsőszerkezetek ipari létesítményekhez. Speciális felületkezelés: 
                        horganyzás, festés, impregnálás a hosszú élettartam érdekében.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ipari létesítmények
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Időjárásálló kivitelezés
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Speciális felületkezelés
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Horganyzás, festés, impregnálás
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-shield-alt mr-2"></i>
                            Minden kültéri lépcső speciális védőbevonattal a hosszú élettartamért
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Anyagválaszték -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Széles <span class="text-secondary">anyagválaszték</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Anyagválaszték: acél, alumínium, fa vagy ezek kombinációja. Minden anyag tökéletesen 
                    illeszkedik az adott tér stílusához és funkcionális igényeihez, biztosítva a tartósságot és esztétikumot.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-hammer text-secondary mr-3"></i>
                            Acél szerkezetek
                        </h4>
                        <p class="text-gray-600">Tartós, nagy teherbírású megoldások minden típusú építményre</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-feather text-secondary mr-3"></i>
                            Alumínium konstrukciók
                        </h4>
                        <p class="text-gray-600">Könnyű, korrózióálló megoldások modern megjelenéssel</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-tree text-secondary mr-3"></i>
                            Fa és kombinált megoldások
                        </h4>
                        <p class="text-gray-600">Természetes anyagok és fém kombinációja harmonikus megjelenésért</p>
                    </div>
                </div>
            </div>
            
            <!-- Anyag típusok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Anyagaink előnyei</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-shield-alt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Tartósság</h5>
                        <p class="text-sm text-gray-600">Hosszú élettartamú anyagok</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-eye text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Esztétikum</h5>
                        <p class="text-sm text-gray-600">Szép és stílusos megjelenés</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-tools text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Könnyű karbantartás</h5>
                        <p class="text-sm text-gray-600">Minimális gondozási igény</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-recycle text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Környezetbarát</h5>
                        <p class="text-sm text-gray-600">Újrahasznosítható anyagok</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Felületkezelés és védelem -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Felületkezelés és védelem</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Felületkezelés kültéri lépcsőknél: horganyzás, festés, impregnálás a hosszú élettartam érdekében
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Horganyzás -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Horganyzás</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Kiváló korrózióvédelem acél szerkezeteknél. A horganyzott felület évtizedekig véd 
                        a rozsdásodás ellen, minimális karbantartást igényel.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Hosszú távú védelem</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Korrózióállóság</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Minimális karbantartás</li>
                    </ul>
                </div>
            </div>
            
            <!-- Festés -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-palette text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Festés</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Speciális külső festékekkel biztosítjuk a színek tartósságát és az időjárásállóságot. 
                        Széles színválaszték minden stílushoz.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Időjárásálló festékek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Széles színválaszték</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>UV-álló tulajdonságok</li>
                    </ul>
                </div>
            </div>
            
            <!-- Impregnálás -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-tree text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Fa impregnálás</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Fa elemek védelme speciális impregnáló szerekkel a rovar- és gombakártételek, 
                        valamint az időjárási hatások ellen.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Rovar- és gombavédelem</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Időjárásállóság</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Természetes megjelenés</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Kivitelezési folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Gyors, precíz kivitelezés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden lépcsőszerkezet kivitelezése a műszaki és biztonsági előírások maximális betartásával történik
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Helyszíni felmérés</h3>
                <p class="text-gray-600">Részletes felmérés és igények egyeztetése a helyszínen</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Személyre szabott tervezés</h3>
                <p class="text-gray-600">Egyedi tervezés a helyszín adottságaihoz és igényekhez</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Precíz gyártás</h3>
                <p class="text-gray-600">Műhelyi gyártás a legmagasabb minőségi követelményekkel</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szakszerű beépítés</h3>
                <p class="text-gray-600">Gyors és precíz telepítés minden előírás betartásával</p>
            </div>
        </div>
    </div>
</section>

<!-- Alkalmazási területek -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Minden típusú épülethez</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Legyen szó családi házról, irodaépületről vagy ipari létesítményről, megbízható és tartós 
                lépcsőszerkezeteket készítünk minden igényre
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-home text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Családi házak</h3>
                <p class="opacity-90">Beltéri és kültéri lépcsők lakóépületekhez</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-building text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Irodaépületek</h3>
                <p class="opacity-90">Reprezentatív megjelenésű lépcsőszerkezetek</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-industry text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Ipari létesítmények</h3>
                <p class="opacity-90">Nagy teherbírású, biztonságos megoldások</p>
            </div>
        </div>
    </div>
</section>

<!-- Előnyök -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Miért válassza a BDSTEEL lépcsőszerkezeteit?</h2>
            <p class="text-xl text-gray-700 max-w-3xl mx-auto">
                Garantáljuk a biztonságot és az esztétikus megjelenést minden projektünknél
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-shield-alt text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Biztonság</h4>
                <p class="text-gray-600 text-sm">Minden előírás betartása és tartós konstrukció</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-eye text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Esztétikum</h4>
                <p class="text-gray-600 text-sm">Szép megjelenés és harmonikus illeszkedés</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-clock text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Gyors kivitelezés</h4>
                <p class="text-gray-600 text-sm">Határidők pontos betartása</p>
            </div>
            
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-handshake text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Megbízhatóság</h4>
                <p class="text-gray-600 text-sm">Évtizedes tapasztalat és garancia</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Tervezze meg egyedi lépcsőszerkezetét velünk!
        </h2>
        <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes helyszíni felméréséért és személyre szabott tervezésért. 
            Minden lépcsőszerkezet egyedi igények szerint készül.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-calendar mr-2"></i>Időpont egyeztetés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>