<?php
$page_title = 'Lépcsőépítés';
$page_description = 'Egyedi lépcsőszerkezetek tervezése és kivitelezése Budapesten - beltéri és kültéri lépcsők, lépcsőtartók, korlátok. BDSTEEL professzionális lépcsőépítési szolgáltatások.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-secondary via-primary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Egyedi <span class="text-accent">Lépcsőépítés</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Lépcsőszerkezetek tervezése és kivitelezése a teljes folyamatot lefedve - a tervezéstől a végleges telepítésig. 
            Specializálódtunk mind beltéri, mind kültéri lépcsőszerkezetek készítésére.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Ingyenes felmérés
            </a>
            <a href="#lepcsotipusok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-stairs mr-2"></i>Lépcső típusok
            </a>
        </div>
    </div>
</section>

<!-- Beltéri lépcsőszerkezetek -->
<section id="lepcsotipusok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Beltéri lépcsőszerkezetek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Elegáns és funkcionális beltéri lépcsőszerkezetek készítése lakóházakhoz, irodaépületekhez és 
                kereskedelmi létesítményekhez. Minden lépcső egyedi tervezésű.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Modern beltéri lépcsők -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-home text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Modern beltéri lépcsők</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Elegáns és funkcionális beltéri lépcsőszerkezetek készítése minden építészeti stílushoz. 
                        Figyelembe vesszük a tér adottságait és az építészeti harmóniát.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Lakóházak számára
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Irodaépületek részére
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Kereskedelmi létesítmények
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyedi építészeti stílus
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-palette mr-2"></i>
                            Minden lépcső egyedi tervezésű, figyelembe véve a tér adottságait
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Lépcsőtartók és váz szerkezetek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-drafting-compass text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Lépcsőtartók és váz szerkezetek</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Merész és innovatív lépcsőtartó megoldások, amelyek egyszerre biztosítják a stabilitást 
                        és a vizuális könnyedséget. Precíz mérnöki számítások alapján.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Innovatív lépcsőtartók
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Vizuális könnyedség
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Mérnöki számítások
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Biztonságos használat
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-calculator mr-2"></i>
                            Minden lépcsőtartó precíz mérnöki számítások alapján készül
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Kültéri lépcsőszerkezetek -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    Kültéri <span class="text-secondary">lépcsőszerkezetek</span>
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Tartós kültéri lépcsőszerkezetek, amelyek ellenállnak minden időjárási viszontagságnak. 
                    Speciális felületkezelés és korróziógátló bevonatok alkalmazása a hosszú élettartam érdekében.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-cloud-rain text-secondary mr-3"></i>
                            Időjárásálló megoldások
                        </h4>
                        <p class="text-gray-600">Speciális felületkezelés és korróziógátló bevonatok minden kültéri lépcsőnél</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-industry text-secondary mr-3"></i>
                            Ipari és kereskedelmi lépcsők
                        </h4>
                        <p class="text-gray-600">Nagy teherbírású lépcsők ipari létesítményekhez és raktárakhoz</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Biztonsági előírások
                        </h4>
                        <p class="text-gray-600">Minden lépcső a vonatkozó biztonsági előírásoknak megfelelően készül</p>
                    </div>
                </div>
            </div>
            
            <!-- Kültéri lépcső típusok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Kültéri lépcső típusaink</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-home text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Lakóépületek</h5>
                        <p class="text-sm text-gray-600">Családi házak és társasházak részére</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-building text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Irodaházak</h5>
                        <p class="text-sm text-gray-600">Reprezentatív megjelenésű lépcsők</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-warehouse text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Ipari létesítmények</h5>
                        <p class="text-sm text-gray-600">Nagy teherbírású megoldások</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-store text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Kereskedelmi épületek</h5>
                        <p class="text-sm text-gray-600">Esztétikus és funkcionális</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Korlátok és védőelemek -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Korlátok és védőelemek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Stílusos és biztonságos lépcsőkorlátok minden típusú lépcsőszerkezethez. 
                Kiemelt figyelmet fordítunk a biztonságra és az építészeti harmóniára.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Beltéri korlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-hand-paper text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Beltéri korlátok</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Elegáns beltéri korlátok, amelyek tökéletesen illeszkednek a lépcső stílusához és 
                        a belső térhez. Modern és klasszikus megoldások.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Modern dizájn</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Klasszikus stílus</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Egyedi kivitelezés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Kültéri korlátok -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Kültéri korlátok</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Időjárásálló kültéri korlátok speciális bevonatolással. 
                        Biztonságos és tartós megoldások minden körülmény között.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Időjárásálló</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Korróziógátló</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Tartós kivitelezés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Biztonsági elemek -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-hard-hat text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Biztonsági elemek</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Fokozott biztonsági elemek ipari és kereskedelmi környezethez. 
                        Minden szabványnak megfelelő védőelemek.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Ipari szabványok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Fokozott biztonság</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Előírás szerinti</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lépcsőépítés folyamata -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">A lépcsőépítés folyamata</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden lépcsőépítési projekt egyedi helyszíni felméréssel és részletes konzultációval kezdődik
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Tervezés -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-drafting-compass text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Tervezés és konzultáció</h3>
                <p class="text-gray-600 leading-relaxed">
                    Minden lépcsőépítési projekt egyedi helyszíni felméréssel és részletes konzultációval kezdődik. 
                    Megvizsgáljuk a tér adottságait, az igényeket és a lehetőségeket.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• Helyszíni felmérés</li>
                        <li>• Igények egyeztetése</li>
                        <li>• Lehetőségek felmérése</li>
                    </ul>
                </div>
            </div>
            
            <!-- Gyártás -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-tools text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Egyedi gyártás</h3>
                <p class="text-gray-600 leading-relaxed">
                    Minden lépcsőszerkezet egyedi méretek szerint, műhelyünkben készül. 
                    Precíz munkavégzés és minőségi alapanyagok garantálják a tartós eredményt.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• Egyedi méretek</li>
                        <li>• Minőségi anyagok</li>
                        <li>• Precíz munkavégzés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Telepítés -->
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-24 h-24 rounded-3xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-xl">
                    <i class="fas fa-hammer text-white text-3xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-tertiary mb-4">Professzionális telepítés</h3>
                <p class="text-gray-600 leading-relaxed">
                    Szakértő csapatunk gondoskodik a lépcső biztonságos és precíz telepítéséről. 
                    Minden szerelési munkát garanciavállalással végzünk.
                </p>
                <div class="mt-4 bg-accent/20 rounded-xl p-4">
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>• Szakértő csapat</li>
                        <li>• Biztonságos telepítés</li>
                        <li>• Garanciavállalás</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lépcsőépítési előnyök -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">BDSTEEL lépcsőépítési szakértelem</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Évek óta készítünk egyedi lépcsőszerkezeteket, amelyek nemcsak funkcionálisak, 
                hanem vizuálisan is lenyűgözőek
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-eye text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Esztétikum</h3>
                <p class="opacity-90">Nemcsak praktikus megoldások, hanem designelemek is</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-shield-alt text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Biztonság</h3>
                <p class="opacity-90">Kiemelt figyelmet fordítunk a biztonságra minden projektnél</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-gem text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Tartósság</h3>
                <p class="opacity-90">Hosszú távú megoldások kiváló minőségű anyagokból</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-chart-line text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Értéknövelés</h3>
                <p class="opacity-90">Lépcsőink az épület értékét növelő designelemek</p>
            </div>
        </div>
    </div>
</section>

<!-- Statisztikák szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div class="group">
                <div class="text-4xl md:text-6xl font-bold text-tertiary mb-2 group-hover:scale-110 transition-transform duration-300">200+</div>
                <div class="text-gray-700 font-semibold">Elkészült lépcső</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-6xl font-bold text-tertiary mb-2 group-hover:scale-110 transition-transform duration-300">15+</div>
                <div class="text-gray-700 font-semibold">Év tapasztalat</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-6xl font-bold text-tertiary mb-2 group-hover:scale-110 transition-transform duration-300">100%</div>
                <div class="text-gray-700 font-semibold">Elégedett ügyfél</div>
            </div>
            <div class="group">
                <div class="text-4xl md:text-6xl font-bold text-tertiary mb-2 group-hover:scale-110 transition-transform duration-300">50+</div>
                <div class="text-gray-700 font-semibold">Egyedi projekt</div>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Tervezze meg álmai lépcsőjét velünk!
        </h2>
        <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes helyszíni felméréséért és konzultációért. 
            Minden lépcsőépítési projekt egyedi tervezéssel és precíz kivitelezéssel.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>E-mail küldése
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-calendar mr-2"></i>Időpont egyeztetés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>