<?php
$page_title = 'Műhely Üzletberendezés Gyártása';
$page_description = 'Egyedi műhely berendezések gyártása Budapesten - munkaasztalok, tárolórendszerek, ipari bútorok. BDSTEEL funkcjonális megoldások műhelyek, szervizek és ipari műhelyek számára.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-tertiary via-primary to-secondary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Műhely <span class="text-accent">Üzletberendezés</span> Gyártása
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Egyedi, funkcionális megoldások. Vállaljuk műhelyek, szervizek és ipari műhelyek üzletberendezéseinek 
            tervezését és gyártását, hogy munkaterületei praktikusak, rendezettek és hatékonyak legyenek.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Ergonomikus tervezés
            </a>
            <a href="#berendezesek" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-toolbox mr-2"></i>Berendezések
            </a>
        </div>
    </div>
</section>

<!-- Műhely berendezés típusok -->
<section id="berendezesek" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Komplett műhely berendezések</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Egyedi igények alapján készítünk szerszámtartókat, munkapadokat, polcrendszereket és speciális 
                tárolómegoldásokat, amelyek hosszú távon támogatják a napi munkavégzést.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Munkaasztalok -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-hammer text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Munkaasztalok</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Strapabíró munkaasztalok egyedi méretre és funkcióra szabva. 
                        Ergonomikus tervezés a kényelmes és biztonságos használat érdekében.
                    </p>
                    <ul class="space-y-3">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyedi méretek
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Strapabíró anyagok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ergonomikus kialakítás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Integrált tárolási lehetőségek
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Szerszámtartók -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-tools text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Szerszámtartók</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Praktikus szerszámtartók és tárolási megoldások minden típusú szerszámhoz. 
                        Könnyű hozzáférés és rendezett munkaterület biztosítása.
                    </p>
                    <ul class="space-y-3">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Minden szerszámtípushoz
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Könnyen elérhető
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Rendezett tárolás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Moduláris rendszer
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Polcrendszerek -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-boxes text-white text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-tertiary mb-4">Polcrendszerek</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Hatékony polcrendszerek és tárolóegységek optimális helyfelhasználással. 
                        Minden polc a műhely specifikus igényeihez tervezve.
                    </p>
                    <ul class="space-y-3">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Optimális helyfelhasználás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Állítható polcok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Nagy teherbírás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Moduláris bővíthetőség
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Anyagok és kivitelezés -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    <span class="text-secondary">Tartós, strapabíró</span> anyagok
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Tartós, strapabíró anyagok felhasználása (fém, fa, kombinált megoldások). 
                    Egyedi méretre és funkcióra szabott berendezések gyártása minden műhely igényeihez.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-hammer text-secondary mr-3"></i>
                            Fém konstrukciók
                        </h4>
                        <p class="text-gray-600">Tartós acél és alumínium vázszerkezetek nagy terhelhetőséggel</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-tree text-secondary mr-3"></i>
                            Fa elemek
                        </h4>
                        <p class="text-gray-600">Minőségi fa munkalapok és tárolóelemek megfelelő védőkezeléssel</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-puzzle-piece text-secondary mr-3"></i>
                            Kombinált megoldások
                        </h4>
                        <p class="text-gray-600">Fém és fa anyagok optimális ötvözése funkcionalitás és esztétikum érdekében</p>
                    </div>
                </div>
            </div>
            
            <!-- Anyag előnyök -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Anyagaink előnyei</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-shield-alt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Strapabírás</h5>
                        <p class="text-sm text-gray-600">Nehéz műhelyi körülményeknek ellenálló anyagok</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-clock text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Hosszú élettartam</h5>
                        <p class="text-sm text-gray-600">Évtizedes használatra tervezett konstrukciók</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-tools text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Könnyű karbantartás</h5>
                        <p class="text-sm text-gray-600">Minimális gondozást igénylő felületek</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-recycle text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Környezetbarát</h5>
                        <p class="text-sm text-gray-600">Újrahasznosítható és fenntartható anyagok</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Ergonomikus tervezés -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Ergonomikus tervezés és felületkezelés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Ergonomikus tervezés a kényelmes és biztonságos használat érdekében. 
                Felületkezelés, festés a műhelyi környezetnek megfelelően.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Ergonomikus kialakítás -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-secondary to-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-user text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Kényelmes használat</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Minden berendezés az emberi test természetes mozgásaihoz igazított magasságokkal 
                        és elrendezéssel tervezve a komfort maximalizálása érdekében.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Optimális munkaméretek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Természetes munkahelyzetek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Kényelmes hozzáférés</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Fáradás csökkentés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Biztonságos munkavégzés -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-hard-hat text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Biztonságos használat</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Minden berendezés kialakításánál kiemelt figyelmet fordítunk a munkabiztonságra. 
                        Éles sarkok elkerülése, stabil konstrukciók és biztonságos rögzítési módok.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Biztonságos kialakítás</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Stabil konstrukciók</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Éles sarkok elkerülése</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Megbízható rögzítés</li>
                    </ul>
                </div>
            </div>
            
            <!-- Műhelyi felületkezelés -->
            <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden group">
                <div class="p-8">
                    <div class="bg-gradient-to-br from-tertiary to-primary w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-palette text-white text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold text-tertiary mb-4">Műhelyi felületkezelés</h3>
                    <p class="text-gray-600 mb-4 leading-relaxed">
                        Speciális felületkezelés és festés a műhelyi környezet sajátosságaihoz igazítva. 
                        Olaj-, zsír- és vegyszerálló bevonatok alkalmazása.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li><i class="fas fa-check text-secondary mr-2"></i>Olajálló bevonatok</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Vegyszerálló felületek</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Könnyen tisztítható</li>
                        <li><i class="fas fa-check text-secondary mr-2"></i>Kopásálló festés</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatási folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Gyors szállítás és beüzemelés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Legyen szó új műhely berendezéséről vagy meglévő rendszerek bővítéséről, 
                szakértő csapatunk segít megtalálni a legjobb megoldást
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Igényfelmérés</h3>
                <p class="text-gray-600">Részletes konzultáció a műhely igényeinek és lehetőségeinek felmérése</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Egyedi tervezés</h3>
                <p class="text-gray-600">Méretre és funkcióra szabott berendezések tervezése</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Precíz gyártás</h3>
                <p class="text-gray-600">Műhelyi gyártás strapabíró anyagokból, minden részletre figyelve</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Gyors beüzemelés</h3>
                <p class="text-gray-600">Szállítás és szakszerű beüzemelés minimális üzemszünettél</p>
            </div>
        </div>
    </div>
</section>

<!-- Műhely típusok -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Minden típusú műhelynek</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Szakértő csapatunk segít megtalálni a legjobb megoldást minden műhely típusához
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-car text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Autószervizek</h3>
                <p class="opacity-90">Speciális munkapadok és szerszámtartók gépjárműjavításhoz</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-industry text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Ipari műhelyek</h3>
                <p class="opacity-90">Nagy teherbírású berendezések ipari gyártáshoz</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-hammer text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Kisiparos műhelyek</h3>
                <p class="opacity-90">Kompakt és hatékony megoldások kisebb helyiségekhez</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Rendezze be műhelyét professzionálisan!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot műhelye berendezésének megtervezéséért és gyártásáért. 
            Egyedi megoldások minden munkaterület hatékony kialakításához.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-drafting-compass mr-2"></i>Műhely tervezés
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>