<?php
$page_title = 'Rakodó Rámpák Gyártása és Telepítése';
$page_description = 'Egyedi rakodó rámpák gyártása és telepítése Budapesten - ipari rámpák, raktári megoldások, tehergépjármű rámpák. BDSTEEL strapabíró anyagokból készített rakodó rámpák vállalkozásoknak.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-tertiary via-primary to-secondary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            Rakodó Rámpák <span class="text-accent">Gyártása és Telepítése</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Vállaljuk egyedi méretű és teherbírású rakodó rámpák gyártását és szakszerű telepítését 
            vállalkozások, raktárak és ipari létesítmények számára. Biztonságos és hatékony áruforgalom garantálva.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Helyszíni felmérés
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-truck-loading mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Főbb szolgáltatások -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Egyedi méretű és teherbírású rakodó rámpák</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Rámpáinkat strapabíró anyagokból készítjük, így biztosítva a biztonságos és hatékony áruforgalmat. 
                Minden rámpa egyedi igények szerint tervezve és gyártva.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Ipari rámpák -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-industry text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ipari rakodó rámpák</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Nagy teherbírású ipari rámpák vállalkozások és raktárak számára. 
                        Strapabíró anyagokból készülnek, biztosítva a biztonságos és hatékony áruforgalmat.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Nagy teherbírású konstrukció
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Vállalkozások számára optimalizált
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Strapabíró anyagok
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Biztonságos áruforgalom
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-weight-hanging mr-2"></i>
                            Minden ipari rámpa egyedi teherbírással és méretekkel készül
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Raktári rámpák -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-warehouse text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Raktári rakodó rámpák</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Speciálisan raktárak és logisztikai központok számára tervezett rámpák. 
                        Hatékony árumozgatást és gyors rakodást tesznek lehetővé minden körülmény között.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Raktárak számára optimalizált
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Logisztikai központokhoz
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Hatékony árumozgatás
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Gyors rakodás
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-boxes mr-2"></i>
                            Raktári folyamatok optimalizálására tervezett megoldások
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Szolgáltatási folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Teljes körű szolgáltatásunk</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Szolgáltatásunk magában foglalja a helyszíni felmérést és egyedi igények szerinti tervezést, 
                tartós rámpák gyártását és szakszerű telepítést
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Helyszíni felmérés</h3>
                <p class="text-gray-600">Részletes helyszíni vizsgálat és igények felmérése szakértő csapatunkkal</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Egyedi tervezés</h3>
                <p class="text-gray-600">Egyedi igények szerinti tervezés a helyszín adottságaihoz igazítva</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Tartós gyártás</h3>
                <p class="text-gray-600">Korrózióálló acélból készült rámpák gyártása a legnagyobb tartósságért</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szakszerű telepítés</h3>
                <p class="text-gray-600">Gyors és precíz telepítés munkavédelmi előírások betartásával</p>
            </div>
        </div>
    </div>
</section>

<!-- Anyagminőség és konstrukció -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    <span class="text-secondary">Korrózióálló acélból</span> készült rámpák
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Tartós, korrózióálló acélból készült rámpák gyártása. Gyors és precíz telepítést, 
                    a munkavédelmi előírások maximális betartásával végzünk minden projektnél.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-shield-alt text-secondary mr-3"></i>
                            Korrózióálló acél
                        </h4>
                        <p class="text-gray-600">Hosszú élettartam és minimális karbantartási igény</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-hard-hat text-secondary mr-3"></i>
                            Munkavédelmi előírások
                        </h4>
                        <p class="text-gray-600">Minden telephely a biztonsági szabványok szerint</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-clock text-secondary mr-3"></i>
                            Gyors telepítés
                        </h4>
                        <p class="text-gray-600">Minimális üzemszünet, hatékony munkaszervezés</p>
                    </div>
                </div>
            </div>
            
            <!-- Rámpa jellemzők -->
            <div class="bg-white rounded-3xl p-8 shadow-xl">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Rámpáink jellemzői</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-weight-hanging text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Nagy teherbírás</h5>
                            <p class="text-sm text-gray-600">Akár 20 tonnás terhelésig</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-ruler text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Egyedi méretek</h5>
                            <p class="text-sm text-gray-600">Pontos illeszkedés minden helyszínhez</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-grip-lines text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Csúszásmentes felület</h5>
                            <p class="text-sm text-gray-600">Biztonságos közlekedés minden időben</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center p-4 bg-gray-50 rounded-xl hover:bg-accent/20 transition-colors duration-300">
                        <i class="fas fa-tools text-secondary text-xl mr-4"></i>
                        <div>
                            <h5 class="font-semibold text-tertiary">Könnyű karbantartás</h5>
                            <p class="text-sm text-gray-600">Minimális gondozási igény</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Alkalmazási területek -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Alkalmazási területek</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Legyen szó raktári, szállítási vagy logisztikai feladatokról, rámpáink megkönnyítik 
                és biztonságossá teszik a rakodási folyamatokat
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Raktári feladatok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300 text-center">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-warehouse text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Raktári feladatok</h3>
                <p class="text-gray-600 leading-relaxed">
                    Hatékony árumozgatás és tárolás raktárakban. Gyors be- és kirakodás, 
                    optimalizált logisztikai folyamatok támogatása.
                </p>
                <ul class="mt-4 space-y-2 text-sm text-gray-600">
                    <li><i class="fas fa-check text-secondary mr-2"></i>Gyors be- és kirakodás</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Hatékony árumozgatás</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Optimalizált folyamatok</li>
                </ul>
            </div>
            
            <!-- Szállítási megoldások -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300 text-center">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-truck text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Szállítási megoldások</h3>
                <p class="text-gray-600 leading-relaxed">
                    Tehergépjárművek biztonságos rakodása és kirakodása. 
                    Különböző magasságok és terhelések kezelése professzionális módon.
                </p>
                <ul class="mt-4 space-y-2 text-sm text-gray-600">
                    <li><i class="fas fa-check text-secondary mr-2"></i>Tehergépjármű rakodás</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Különböző magasságok</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Biztonságos működés</li>
                </ul>
            </div>
            
            <!-- Logisztikai központok -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg hover:shadow-xl transition-shadow duration-300 text-center">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-shipping-fast text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Logisztikai központok</h3>
                <p class="text-gray-600 leading-relaxed">
                    Nagy forgalmú logisztikai központok kiszolgálása. 
                    Folyamatos üzemeltetés és nagy terhelhetőség biztosítása.
                </p>
                <ul class="mt-4 space-y-2 text-sm text-gray-600">
                    <li><i class="fas fa-check text-secondary mr-2"></i>Nagy forgalom kezelése</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Folyamatos üzemeltetés</li>
                    <li><i class="fas fa-check text-secondary mr-2"></i>Nagy terhelhetőség</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Karbantartás és tanácsadás -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Karbantartási tanácsadás</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Igény szerint felületkezelést és karbantartási tanácsadást is biztosítunk 
                a rakodó rámpák hosszú élettartama érdekében
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-paint-brush text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Felületkezelés</h3>
                <p class="opacity-90">Korszerű védőbevonatok az időjárási hatások ellen</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-clipboard-check text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Karbantartási terv</h3>
                <p class="opacity-90">Egyedi karbantartási ütemterv készítése</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-user-tie text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Szakértő tanácsadás</h3>
                <p class="opacity-90">Folyamatos szakmai támogatás és tanácsadás</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-wrench text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Szervizelés</h3>
                <p class="opacity-90">Gyors szervizelés és javítási szolgáltatások</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Keressen minket bizalommal!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot, hogy az Ön vállalkozása is profi és megbízható rakodó rámpával dolgozhasson! 
            Helyszíni felmérés és egyedi tervezés minden projekt esetén.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-industry mr-2"></i>Ipari konzultáció
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>