<?php
$page_title = 'Vasszerkezet Gyártás';
$page_description = 'Egyedi vasszerkezetek gyártása Budapesten ipari, kereskedelmi és lakossági felhasználásra - acél- és vasszerkezetek, hegesztett és csavarozott megoldások. BDSTEEL precíz vasszerkezet gyártás.';
include 'header.php';
?>

<!-- Hero szekció -->
<section class="relative py-24 bg-gradient-to-br from-primary via-secondary to-tertiary overflow-hidden">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative z-10 container mx-auto px-4 text-center text-white">
        <h1 class="text-5xl md:text-6xl font-bold mb-6 text-shadow">
            <span class="text-accent">Vasszerkezet</span> Gyártás
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto opacity-90">
            Precíz, tartós megoldások minden projekthez. Vállaljuk egyedi vasszerkezetek gyártását ipari, 
            kereskedelmi és lakossági felhasználásra. Bonyolult, nagy teherbírású szerkezetek tervezése és kivitelezése.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-accent hover:bg-accent-dark text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-2xl">
                <i class="fas fa-phone mr-2"></i>Helyszíni felmérés
            </a>
            <a href="#szolgaltatasok" class="bg-transparent border-2 border-white hover:bg-white hover:text-tertiary text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-industry mr-2"></i>Szolgáltatások
            </a>
        </div>
    </div>
</section>

<!-- Főbb szolgáltatások -->
<section id="szolgaltatasok" class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Széles körű tapasztalat minden területen</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Széles körű tapasztalatunknak köszönhetően képesek vagyunk bonyolult, nagy teherbírású szerkezetek 
                tervezésére és kivitelezésére is. Minden projekt egyedi megközelítést kap.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Ipari felhasználás -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-secondary to-secondary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-industry text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Ipari felhasználás</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Tartós, minőségi acél- és vasszerkezetek gyártása ipari létesítmények számára. 
                        Bonyolult, nagy teherbírású szerkezetek tervezése és kivitelezése.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Ipari létesítményekhez
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Nagy teherbírású szerkezetek
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Bonyolult konstrukciók
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Precíz tervezés és kivitelezés
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-cogs mr-2"></i>
                            Speciálisan ipari környezethez tervezett megoldások
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Kereskedelmi felhasználás -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-primary to-primary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-store text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Kereskedelmi felhasználás</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Kereskedelmi épületek és üzletek számára készített vasszerkezetek. 
                        Funkcionális és esztétikus megoldások minden kereskedelmi igényre.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Kereskedelmi épületekhez
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Üzletek kialakításához
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Funkcionális megoldások
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Esztétikus kivitelezés
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-shopping-cart mr-2"></i>
                            Kereskedelmi környezethez optimalizált szerkezetek
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Lakossági felhasználás -->
            <div class="bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden">
                <div class="p-8">
                    <div class="flex items-center mb-6">
                        <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-16 h-16 rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-home text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-tertiary">Lakossági felhasználás</h3>
                    </div>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        Családi házak és lakossági építkezések vasszerkezetei. 
                        Egyedi igények szerint tervezett és kivitelezett megoldások.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Családi házakhoz
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Lakossági építkezésekhez
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Egyedi igények szerint
                        </li>
                        <li class="flex items-center text-gray-600">
                            <i class="fas fa-check-circle text-secondary mr-3"></i>
                            Személyre szabott megoldások
                        </li>
                    </ul>
                    <div class="bg-accent/20 rounded-2xl p-4">
                        <p class="text-sm text-tertiary font-semibold">
                            <i class="fas fa-heart mr-2"></i>
                            Otthonok számára tervezett biztonságos szerkezetek
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Gyártási technikák -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Tartalom -->
            <div class="space-y-6">
                <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
                    <span class="text-secondary">Hegesztett és csavarozott</span> megoldások
                </h2>
                <p class="text-xl text-gray-600 leading-relaxed">
                    Hegesztett és csavarozott megoldások, az ügyfél igényei szerint. Helyszíni felmérés és tanácsadás 
                    a megfelelő megoldás kiválasztásához. Minden technika előnyeinek optimális kihasználása.
                </p>
                
                <div class="space-y-4">
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-fire text-secondary mr-3"></i>
                            Hegesztett szerkezetek
                        </h4>
                        <p class="text-gray-600">Erős, tartós kapcsolatok nagy terhelhetőséggel</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-wrench text-secondary mr-3"></i>
                            Csavarozott megoldások
                        </h4>
                        <p class="text-gray-600">Rugalmas, szétszerelhető konstrukciók</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-accent/20 to-transparent rounded-2xl p-6 hover:from-accent/30 transition-all duration-300">
                        <h4 class="font-bold text-tertiary mb-2 flex items-center">
                            <i class="fas fa-user-tie text-secondary mr-3"></i>
                            Szakértő tanácsadás
                        </h4>
                        <p class="text-gray-600">A legmegfelelőbb technológia kiválasztásában segítünk</p>
                    </div>
                </div>
            </div>
            
            <!-- Technikai előnyök -->
            <div class="bg-gradient-to-br from-gray-50 to-accent/10 rounded-3xl p-8 shadow-lg">
                <h3 class="text-2xl font-bold text-tertiary mb-6 text-center">Technikai előnyök</h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-hammer text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Hegesztés előnyei</h5>
                        <p class="text-sm text-gray-600">Folyamatos, erős kötés, nagy terhelhetőség</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-bolt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Csavarozás előnyei</h5>
                        <p class="text-sm text-gray-600">Szétszerelhető, módosítható konstrukció</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-shield-alt text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Tartósság</h5>
                        <p class="text-sm text-gray-600">Hosszú élettartam mindkét technikánál</p>
                    </div>
                    
                    <div class="bg-white rounded-xl p-4 shadow-md hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-clock text-secondary text-2xl mb-3"></i>
                        <h5 class="font-semibold text-tertiary mb-2">Gyors kivitelezés</h5>
                        <p class="text-sm text-gray-600">Hatékony munkamódszerek alkalmazása</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Projekt típusok -->
<section class="py-20 bg-gradient-to-br from-gray-50 to-accent/20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Vasszerkezeti projekt típusaink</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Legyen szó állványzatról, tartókeretről, csarnokszerkezetről vagy bármilyen egyedi projekt megvalósításáról, 
                ránk számíthat a megbízhatóság és a minőség terén
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Állványzatok -->
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-hard-hat text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Állványzatok</h4>
                <p class="text-gray-600 text-sm">Biztonságos és stabil állványzatok minden magasságban</p>
            </div>
            
            <!-- Tartókeretek -->
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-grip-horizontal text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Tartókeretek</h4>
                <p class="text-gray-600 text-sm">Nagy teherbírású tartószerkezetek és keretek</p>
            </div>
            
            <!-- Csarnokszerkezetek -->
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-warehouse text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Csarnokszerkezetek</h4>
                <p class="text-gray-600 text-sm">Komplett ipari csarnokok vasszerkezetei</p>
            </div>
            
            <!-- Egyedi projektek -->
            <div class="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 text-center">
                <i class="fas fa-puzzle-piece text-secondary text-3xl mb-4"></i>
                <h4 class="font-bold text-tertiary mb-2">Egyedi projektek</h4>
                <p class="text-gray-600 text-sm">Speciális igényekre szabott megoldások</p>
            </div>
        </div>
    </div>
</section>

<!-- Gyártási folyamat -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">Gyors gyártás és precíz szerelés</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Minden vasszerkezeti projekt gondos tervezéssel kezdődik és precíz kivitelezéssel zárul
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="bg-gradient-to-br from-secondary to-secondary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Helyszíni felmérés</h3>
                <p class="text-gray-600">Részletes felmérés és tanácsadás a megfelelő megoldás kiválasztásához</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-primary to-primary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Tervezés</h3>
                <p class="text-gray-600">Precíz műszaki tervezés és statikai számítások készítése</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-tertiary to-tertiary-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Gyors gyártás</h3>
                <p class="text-gray-600">Hatékony műhelyi gyártás tartós, minőségi anyagokból</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-gradient-to-br from-accent to-accent-dark w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                    <span class="text-2xl font-bold text-tertiary">4</span>
                </div>
                <h3 class="text-xl font-bold text-tertiary mb-4">Precíz szerelés</h3>
                <p class="text-gray-600">Szakszerű helyszíni szerelés és végleges beüzemelés</p>
            </div>
        </div>
    </div>
</section>

<!-- Felületkezelés -->
<section class="py-20 bg-gradient-to-br from-tertiary to-primary text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-6">Felületkezelés a hosszú élettartamért</h2>
            <p class="text-xl opacity-90 max-w-3xl mx-auto">
                Felületkezelés (horganyzás, festés) a hosszú élettartamért. Minden vasszerkezet védett 
                a korrózió és időjárási hatások ellen
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-shield-alt text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Horganyzás</h3>
                <p class="opacity-90">Kiváló korrózióvédelem évtizedes tartóssággal</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-palette text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Festés</h3>
                <p class="opacity-90">Időjárásálló festékekkel a színtartósságért</p>
            </div>
            
            <div class="text-center group">
                <div class="bg-accent w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-clock text-tertiary text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">Hosszú élettartam</h3>
                <p class="opacity-90">Minimális karbantartással évtizedes használat</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA szekció -->
<section class="py-20 bg-accent">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold text-tertiary mb-6">
            Valósítsa meg vasszerkezeti projektjét velünk!
        </h2>
        <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Vegye fel velünk a kapcsolatot ingyenes helyszíni felméréséért és szakértő tanácsadásért. 
            Minden vasszerkezet egyedi tervezéssel és precíz kivitelezéssel készül.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:+36706096667" class="bg-secondary hover:bg-secondary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-phone mr-2"></i>+36 70 609 6667
            </a>
            <a href="mailto:bdsteel94@gmail.com" class="bg-tertiary hover:bg-tertiary-dark text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-envelope mr-2"></i>Ingyenes árajánlat
            </a>
            <a href="/kapcsolat" class="bg-transparent border-2 border-tertiary hover:bg-tertiary hover:text-white text-tertiary px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105">
                <i class="fas fa-drafting-compass mr-2"></i>Projekt konzultáció
            </a>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>