<?php
include_once 'config.php';

$url = isset($_GET['url']) ? trim($_GET['url'], '/') : '';

// Ha üres URL, akkor főoldal
if (empty($url)) {
    $url = 'home';
}

// URL slug konverziók az eredeti fájlnevekre
$url_mapping = [
    'home' => 'home',
    'galeria' => 'galeria',
    'kapcsolat' => 'kapcsolat',
    '404' => '404',
    // Szolgáltatás oldalak
    'lepcso-szerkezet-epitese' => 'lepcso-szerkezet-epitese',
    'korlatok-kivitelezese' => 'korlatok-kivitelezese',
    'kapuk-keritesek-felujitasa' => 'kapuk-keritesek-felujitasa',
    'keritesek-kapuk-gyartasa' => 'keritesek-kapuk-gyartasa',
    'biztonsagi-racs-keszites' => 'biztonsagi-racs-keszites',
    'rakodo-rampak' => 'rakodo-rampak',
    'vasszerkezet-gyartas' => 'vasszerkezet-gyartas',
    'muhely-uzletberendezes' => 'muhely-uzletberendezes'
];

// Ellenőrizzük a mapping-ben
if (isset($url_mapping[$url])) {
    $mapped_url = $url_mapping[$url];
    $page_file = 'pages/' . $mapped_url . '.php';
    
    // Ellenőrizzük, hogy létezik-e a fájl
    if (file_exists($page_file)) {
        $current_page = $url;
        
        // SEO adatok globálisan elérhetővé tétele
        global $seo_pages;
        
        include $page_file;
    } else {
        // Ha a fájl nem létezik, 404-et dobunk
        $current_page = '404';
        if (file_exists('pages/404.php')) {
            include 'pages/404.php';
        } else {
            // Alapértelmezett 404 hibaüzenet
            http_response_code(404);
            echo "<!DOCTYPE html><html><head><title>404 - Oldal nem található</title></head><body><h1>404 - Az oldal nem található</h1><p>A keresett szolgáltatás oldal még nem készült el.</p></body></html>";
        }
    }
} else {
    // Ha nincs a mapping-ben, 404 oldal betöltése
    $current_page = '404';
    if (file_exists('pages/404.php')) {
        include 'pages/404.php';
    } else {
        // Alapértelmezett 404 hibaüzenet
        http_response_code(404);
        echo "<!DOCTYPE html><html><head><title>404 - Oldal nem található</title></head><body><h1>404 - Az oldal nem található</h1></body></html>";
    }
}
?>